/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin.ee;

import java.lang.annotation.Annotation;
import java.security.AccessController;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.servlet.ServletContext;
import org.jboss.weld.bean.builtin.AbstractStaticallyDecorableBuiltInBean;
import org.jboss.weld.logging.ServletLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.security.GetContextClassLoaderAction;
import org.jboss.weld.servlet.ServletContextService;

public class ServletContextBean
extends AbstractStaticallyDecorableBuiltInBean<ServletContext> {
    private final ServletContextService servletContexts;

    public ServletContextBean(BeanManagerImpl beanManager) {
        super(beanManager, ServletContext.class);
        this.servletContexts = (ServletContextService)beanManager.getServices().get(ServletContextService.class);
    }

    @Override
    protected ServletContext newInstance(InjectionPoint ip, CreationalContext<ServletContext> creationalContext) {
        ServletContext ctx = this.servletContexts.getCurrentServletContext();
        if (ctx == null) {
            ClassLoader cl = AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
            throw ServletLogger.LOG.cannotInjectServletContext(cl, this.servletContexts);
        }
        return ctx;
    }

    public void destroy(ServletContext instance, CreationalContext<ServletContext> creationalContext) {
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }
}

