/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.builder;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.cl.exception.CommandLineParserException;
import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.internal.ProcessedOption;
import org.jboss.aesh.cl.result.ResultHandler;
import org.jboss.aesh.cl.validator.CommandValidator;

public class CommandBuilder {
    private String name;
    private String description;
    private CommandValidator<?> validator;
    private ResultHandler resultHandler;
    private ProcessedOption argument;
    private final List<ProcessedOption> options = new ArrayList<ProcessedOption>();

    public CommandBuilder name(String name) {
        this.name = name;
        return this;
    }

    public CommandBuilder description(String usage) {
        this.description = usage;
        return this;
    }

    public CommandBuilder argument(ProcessedOption argument) {
        this.argument = argument;
        return this;
    }

    public CommandBuilder validator(CommandValidator<?> validator) {
        this.validator = validator;
        return this;
    }

    public CommandBuilder resultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
        return this;
    }

    public CommandBuilder addOption(ProcessedOption option) {
        this.options.add(option);
        return this;
    }

    public CommandBuilder addOptions(List<ProcessedOption> options) {
        this.options.addAll(options);
        return this;
    }

    public ProcessedCommand generateCommand() throws CommandLineParserException {
        if (this.name == null || this.name.length() < 1) {
            throw new CommandLineParserException("The parameter name must be defined");
        }
        return new ProcessedCommand(this.name, this.description, this.validator, this.resultHandler, this.argument, this.options);
    }
}

