/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.completer;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.console.AeshContext;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.completer.CompleterInvocation;
import org.jboss.aesh.terminal.TerminalString;

public class CompleterData
implements CompleterInvocation {
    private List<TerminalString> completerValues;
    private boolean appendSpace = true;
    private final String completeValue;
    private final Command command;
    private final AeshContext aeshContext;
    private int offset;
    private boolean ignoreOffset = false;
    private boolean ignoreStartsWith = false;

    public CompleterData(AeshContext aeshContext, String completeValue, Command command) {
        this.aeshContext = aeshContext;
        this.completeValue = completeValue;
        this.command = command;
        this.completerValues = new ArrayList<TerminalString>();
    }

    @Override
    public String getGivenCompleteValue() {
        return this.completeValue;
    }

    @Override
    public Command getCommand() {
        return this.command;
    }

    @Override
    public List<TerminalString> getCompleterValues() {
        return this.completerValues;
    }

    @Override
    public void setCompleterValues(List<String> completerValues) {
        for (String s : completerValues) {
            this.completerValues.add(new TerminalString(s, true));
        }
    }

    @Override
    public void setCompleterValuesTerminalString(List<TerminalString> completerValues) {
        this.completerValues = completerValues;
    }

    @Override
    public void clearCompleterValues() {
        this.completerValues.clear();
    }

    @Override
    public void addAllCompleterValues(List<String> completerValues) {
        for (String s : completerValues) {
            this.completerValues.add(new TerminalString(s, true));
        }
    }

    @Override
    public void addCompleterValue(String value) {
        this.completerValues.add(new TerminalString(value, true));
    }

    @Override
    public void addCompleterValueTerminalString(TerminalString value) {
        this.completerValues.add(value);
    }

    @Override
    public boolean isAppendSpace() {
        return this.appendSpace;
    }

    @Override
    public void setAppendSpace(boolean appendSpace) {
        this.appendSpace = appendSpace;
    }

    @Override
    public boolean doIgnoreOffset() {
        return this.ignoreOffset;
    }

    @Override
    public void setIgnoreOffset(boolean ignoreOffset) {
        this.ignoreOffset = ignoreOffset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setIgnoreStartsWith(boolean ignoreStartsWith) {
        this.ignoreStartsWith = ignoreStartsWith;
    }

    @Override
    public boolean isIgnoreStartsWith() {
        return this.ignoreStartsWith;
    }

    @Override
    public AeshContext getAeshContext() {
        return this.aeshContext;
    }
}

