/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ArrayBlockingQueue;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.terminal.Key;

public class AeshInputStream
extends InputStream {
    private final ArrayBlockingQueue<String> blockingQueue;
    private String b;
    private int c;
    private transient boolean stopped = false;

    public AeshInputStream(ArrayBlockingQueue<String> blockingQueue) {
        this.blockingQueue = blockingQueue;
    }

    @Override
    public int read() throws IOException {
        if (this.stopped && this.blockingQueue.size() == 0) {
            return -1;
        }
        try {
            if (this.b == null || this.c == this.b.length()) {
                this.b = this.blockingQueue.take();
                this.c = 0;
            }
            if (this.b != null && this.b.length() != 0) {
                return this.b.charAt(this.c++);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return -1;
    }

    public int[] readAll() {
        if (this.stopped && this.blockingQueue.size() == 0) {
            return new int[]{-1};
        }
        try {
            if (Config.isOSPOSIXCompatible()) {
                String out = this.blockingQueue.take();
                int[] input = new int[out.length()];
                for (int i = 0; i < out.length(); ++i) {
                    input[i] = out.charAt(i);
                }
                return input;
            }
            String out = this.blockingQueue.take();
            if (!(out.isEmpty() || out.charAt(0) != Key.WINDOWS_ESC.getAsChar() && out.charAt(0) != Key.WINDOWS_ESC_2.getAsChar())) {
                int[] input = new int[2];
                if (out.length() == 2) {
                    input[0] = Key.WINDOWS_ESC.getAsChar();
                    input[1] = out.charAt(1);
                } else {
                    input[0] = Key.WINDOWS_ESC.getAsChar();
                    String out2 = this.blockingQueue.take();
                    input[1] = out2.charAt(0);
                }
                return input;
            }
            int[] input = new int[out.length()];
            for (int i = 0; i < out.length(); ++i) {
                input[i] = out.charAt(i);
            }
            return input;
        }
        catch (InterruptedException e) {
            return new int[]{-1};
        }
    }

    @Override
    public int available() {
        if (this.b != null) {
            return this.b.length();
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        if (!this.stopped) {
            this.stopped = true;
            this.blockingQueue.add("");
        }
    }

    public void write(String toBuffer) {
        this.blockingQueue.add(toBuffer);
    }
}

