/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.reader.AeshStandardStream;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.terminal.CursorPosition;
import org.jboss.aesh.terminal.Shell;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.util.ANSI;

public abstract class AbstractTerminal
implements Terminal,
Shell {
    private final Logger logger;
    protected Settings settings;
    private boolean mainBuffer = true;

    AbstractTerminal(Logger logger) {
        this.logger = logger;
    }

    @Override
    public CursorPosition getCursor() {
        if (this.settings.isAnsiConsole() && Config.isOSPOSIXCompatible()) {
            try {
                StringBuilder col = new StringBuilder(4);
                StringBuilder row = new StringBuilder(4);
                this.out().print(ANSI.getCurrentCursorPos());
                this.out().flush();
                boolean gotSep = false;
                int[] input = this.read(true);
                for (int i = 2; i < input.length - 1; ++i) {
                    if (input[i] == 59) {
                        gotSep = true;
                        continue;
                    }
                    if (gotSep) {
                        col.append((char)input[i]);
                        continue;
                    }
                    row.append((char)input[i]);
                }
                return new CursorPosition(Integer.parseInt(row.toString()), Integer.parseInt(col.toString()));
            }
            catch (Exception e) {
                if (this.settings.isLogging()) {
                    this.logger.log(Level.SEVERE, "Failed to find current row with ansi code: ", e);
                }
                return new CursorPosition(-1, -1);
            }
        }
        return new CursorPosition(-1, -1);
    }

    @Override
    public void setCursor(CursorPosition position) {
        if (this.getSize().isPositionWithinSize(position)) {
            this.out().print(position.asAnsi());
            this.out().flush();
        }
    }

    @Override
    public void moveCursor(int rows, int columns) {
        CursorPosition cp = this.getCursor();
        cp.move(rows, columns);
        if (this.getSize().isPositionWithinSize(cp)) {
            this.setCursor(cp);
        }
    }

    @Override
    public void clear() {
        this.out().print(ANSI.clearScreen());
        this.out().flush();
    }

    @Override
    public boolean isMainBuffer() {
        return this.mainBuffer;
    }

    @Override
    public void enableAlternateBuffer() {
        if (this.isMainBuffer()) {
            this.out().print(ANSI.getAlternateBufferScreen());
            this.out().flush();
            this.mainBuffer = false;
        }
    }

    @Override
    public void enableMainBuffer() {
        if (!this.isMainBuffer()) {
            this.out().print(ANSI.getMainBufferScreen());
            this.out().flush();
            this.mainBuffer = true;
        }
    }

    @Override
    public Shell getShell() {
        return this;
    }

    @Override
    public AeshStandardStream in() {
        return null;
    }
}

