/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.simple.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.container.simple.EventListener;
import org.jboss.forge.furnace.container.simple.Service;
import org.jboss.forge.furnace.container.simple.impl.SimpleExportedInstanceImpl;
import org.jboss.forge.furnace.container.simple.impl.SimpleSingletonExportedInstanceImpl;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.spi.ExportedInstance;
import org.jboss.forge.furnace.spi.ServiceRegistry;
import org.jboss.forge.furnace.util.Addons;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.ClassLoaders;

public class SimpleServiceRegistry
implements ServiceRegistry {
    private final Furnace furnace;
    private final Addon addon;
    private final Set<Class<?>> serviceTypes;
    private final Map<String, ExportedInstance<?>> instanceCache = new WeakHashMap();
    private final Map<String, Set<ExportedInstance<?>>> instancesCache = new WeakHashMap();
    private final Set<Class<?>> singletonServiceTypes;

    public SimpleServiceRegistry(Furnace furnace, Addon addon, Set<Class<?>> serviceTypes, Set<Class<?>> singletonServiceTypes) {
        this.furnace = furnace;
        this.addon = addon;
        this.serviceTypes = serviceTypes;
        this.singletonServiceTypes = singletonServiceTypes;
    }

    public <T> Set<ExportedInstance<T>> getExportedInstances(String clazz) {
        try {
            return this.getExportedInstances(Class.forName(clazz, false, this.addon.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            return Collections.emptySet();
        }
    }

    public <T> Set<ExportedInstance<T>> getExportedInstances(Class<T> clazz) {
        Addons.waitUntilStarted((Addon)this.addon);
        Set<ExportedInstance<T>> result = this.instancesCache.get(clazz.getName());
        if (result == null || result.isEmpty()) {
            result = new HashSet();
            for (Class<?> type : this.serviceTypes) {
                if (!clazz.isAssignableFrom(type)) continue;
                result.add(new SimpleExportedInstanceImpl(this.furnace, this.addon, type));
            }
            for (Class<?> type : this.singletonServiceTypes) {
                if (!clazz.isAssignableFrom(type)) continue;
                result.add(new SimpleSingletonExportedInstanceImpl(this.furnace, this.addon, type));
            }
            if (ClassLoaders.ownsClass((ClassLoader)this.addon.getClassLoader(), clazz) && this.isExtensionPointType(clazz)) {
                result.add(new SimpleExportedInstanceImpl<T>(this.furnace, this.addon, clazz));
            }
            this.instancesCache.put(clazz.getName(), result);
        }
        return result;
    }

    public <T> ExportedInstance<T> getExportedInstance(String clazz) {
        try {
            Class<?> type = Class.forName(clazz, false, this.addon.getClassLoader());
            return this.getExportedInstance(type);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public <T> ExportedInstance<T> getExportedInstance(final Class<T> clazz) {
        Assert.notNull(clazz, (String)"Requested Class type may not be null");
        Addons.waitUntilStarted((Addon)this.addon);
        ExportedInstance result = this.instanceCache.get(clazz.getName());
        if (result == null) {
            try {
                result = (ExportedInstance)ClassLoaders.executeIn((ClassLoader)this.addon.getClassLoader(), (Callable)new Callable<ExportedInstance<T>>(){

                    @Override
                    public ExportedInstance<T> call() throws Exception {
                        for (Class type : SimpleServiceRegistry.this.serviceTypes) {
                            if (!clazz.isAssignableFrom(type)) continue;
                            return new SimpleExportedInstanceImpl(SimpleServiceRegistry.this.furnace, SimpleServiceRegistry.this.addon, type);
                        }
                        for (Class type : SimpleServiceRegistry.this.singletonServiceTypes) {
                            if (!clazz.isAssignableFrom(type)) continue;
                            return new SimpleSingletonExportedInstanceImpl(SimpleServiceRegistry.this.furnace, SimpleServiceRegistry.this.addon, type);
                        }
                        if (ClassLoaders.ownsClass((ClassLoader)SimpleServiceRegistry.this.addon.getClassLoader(), (Class)clazz) && SimpleServiceRegistry.this.isExtensionPointType(clazz)) {
                            return new SimpleExportedInstanceImpl(SimpleServiceRegistry.this.furnace, SimpleServiceRegistry.this.addon, clazz);
                        }
                        return null;
                    }
                });
                if (result != null) {
                    this.instanceCache.put(clazz.getName(), result);
                }
            }
            catch (Exception e) {
                throw new ContainerException("Could not get service of type [" + clazz + "] from addon [" + this.addon + "]", (Throwable)e);
            }
        }
        return result;
    }

    private boolean isExtensionPointType(Class<?> clazz) {
        return EventListener.class.isAssignableFrom(clazz) || Service.class.isAssignableFrom(clazz);
    }

    public Set<Class<?>> getExportedTypes() {
        HashSet result = new HashSet();
        result.addAll(this.serviceTypes);
        result.addAll(this.singletonServiceTypes);
        return Collections.unmodifiableSet(result);
    }

    public <T> Set<Class<T>> getExportedTypes(Class<T> type) {
        HashSet<Class<T>> result = new HashSet<Class<T>>();
        for (Class<?> serviceType : this.getExportedTypes()) {
            if (!type.isAssignableFrom(serviceType)) continue;
            result.add(type);
        }
        return result;
    }

    public boolean hasService(Class<?> clazz) {
        Addons.waitUntilStarted((Addon)this.addon);
        for (Class<?> service : this.getExportedTypes()) {
            if (!clazz.isAssignableFrom(service)) continue;
            return true;
        }
        return false;
    }

    public boolean hasService(String clazz) {
        try {
            return this.hasService(Class.forName(clazz, false, this.addon.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String toString() {
        return this.serviceTypes.toString();
    }
}

