/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.condition;

import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.condition.GraphCondition;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryGremlinCriterion;
import org.jboss.windup.config.query.QueryPropertyComparisonType;
import org.jboss.windup.rules.apps.java.condition.JavaClassBuilder;
import org.jboss.windup.rules.apps.java.condition.JavaClassBuilderAt;
import org.jboss.windup.rules.apps.java.condition.JavaClassBuilderInFile;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.TypeInterestFactory;
import org.jboss.windup.rules.apps.java.scan.ast.TypeReferenceLocation;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;

public class JavaClass
extends GraphCondition
implements JavaClassBuilder,
JavaClassBuilderAt,
JavaClassBuilderInFile {
    private final String regex;
    private List<TypeReferenceLocation> locations = Collections.emptyList();
    private String variable = "default";
    private String fileRegex;

    private JavaClass(String regex) {
        this.regex = regex;
        TypeInterestFactory.registerInterest(regex);
    }

    public static JavaClassBuilder references(String regex) {
        return new JavaClass(regex);
    }

    @Override
    public JavaClassBuilderInFile inFile(String regex) {
        this.fileRegex = regex;
        return this;
    }

    @Override
    public JavaClassBuilderAt at(TypeReferenceLocation ... locations) {
        if (locations != null) {
            this.locations = Arrays.asList(locations);
        }
        return this;
    }

    @Override
    public ConditionBuilder as(String variable) {
        Assert.notNull((Object)variable, (String)"Variable name must not be null.");
        this.variable = variable;
        return this;
    }

    public boolean evaluate(GraphRewrite event, EvaluationContext context) {
        Object query = this.getInputVariablesName() != null && !this.getInputVariablesName().equals("") ? Query.from((String)this.getInputVariablesName()) : Query.find(JavaTypeReferenceModel.class);
        query.withProperty("referenceSourceSnippit", QueryPropertyComparisonType.REGEX, (Object)this.regex);
        if (this.fileRegex != null) {
            QueryGremlinCriterion inFileWithName = new QueryGremlinCriterion(){

                public void query(GraphRewrite event, GremlinPipeline<Vertex, Vertex> pipeline) {
                    Predicate regexPredicate = new Predicate(){

                        public boolean evaluate(Object first, Object second) {
                            return ((String)first).matches((String)second);
                        }
                    };
                    pipeline.as("result").out(new String[]{"file"}).out(new String[]{"javaClass"}).has("qualifiedName", regexPredicate, (Object)JavaClass.this.fileRegex).back("result");
                }
            };
            query.piped(inFileWithName);
        }
        if (!this.locations.isEmpty()) {
            query.withProperty("referenceType", this.locations);
        }
        return query.as(this.variable).evaluate((Rewrite)event, context);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JavaClass");
        if (this.fileRegex != null) {
            builder.append(".inFile(" + this.fileRegex + ")");
        }
        if (this.regex != null) {
            builder.append(".references(" + this.regex + ")");
        }
        if (!this.locations.isEmpty()) {
            builder.append(".at(" + this.locations + ")");
        }
        builder.append(".as(" + this.variable + ")");
        return builder.toString();
    }
}

