/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.model;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.Adjacency;
import com.tinkerpop.frames.modules.javahandler.JavaHandler;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerContext;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;

@TypeValue(value="PropertiesModel")
public interface PropertiesModel
extends WindupVertexFrame {
    public static final String PROPERTIES_FILE_RESOURCE = "w:windupPropertiesModelToPropertiesFile";
    public static final String TYPE = "PropertiesModel";

    @Adjacency(label="w:windupPropertiesModelToPropertiesFile", direction=Direction.OUT)
    public FileModel getFileResource();

    @Adjacency(label="w:windupPropertiesModelToPropertiesFile", direction=Direction.OUT)
    public void setFileResource(FileModel var1);

    @JavaHandler
    public void setProperty(String var1, String var2);

    @JavaHandler
    public String getProperty(String var1);

    @JavaHandler
    public Set<String> keySet();

    public static abstract class Impl
    implements PropertiesModel,
    JavaHandlerContext<Vertex> {
        private static final String PREFIX = "P:";

        @Override
        public void setProperty(String key, String value) {
            String encodedKey = Base64.encodeBase64URLSafeString((byte[])key.getBytes());
            String encodedValue = Base64.encodeBase64String((byte[])value.getBytes());
            ((Vertex)this.it()).setProperty(PREFIX + encodedKey, (Object)encodedValue);
        }

        @Override
        public String getProperty(String key) {
            String encodedKey = Base64.encodeBase64URLSafeString((byte[])key.getBytes());
            String encodedValue = (String)((Vertex)this.it()).getProperty(PREFIX + encodedKey);
            return new String(Base64.decodeBase64((String)encodedValue));
        }

        @Override
        public Set<String> keySet() {
            HashSet<String> keySet = new HashSet<String>();
            for (String key : ((Vertex)this.it()).getPropertyKeys()) {
                if (!key.startsWith(PREFIX)) continue;
                String decodedKey = new String(Base64.decodeBase64((String)key.substring(PREFIX.length())));
                keySet.add(decodedKey);
            }
            return keySet;
        }
    }
}

