/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.List;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.roaster.ParserException;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.Extendable;
import org.jboss.forge.roaster.model.InterfaceCapable;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderWith;
import org.jboss.windup.config.query.QueryPropertyComparisonType;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class DiscoverJavaFilesRuleProvider
extends WindupRuleProvider {
    private static final String TECH_TAG = "Java Source";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.INFORMATIONAL;

    public RulePhase getPhase() {
        return RulePhase.POST_DISCOVERY;
    }

    public Configuration getConfiguration(GraphContext context) {
        QueryBuilderWith javaSourceQuery = Query.find(FileModel.class).withProperty("isDirectory", (Object)false).withProperty("filePath", QueryPropertyComparisonType.REGEX, (Object)".*\\.java$");
        return ConfigurationBuilder.begin().addRule().when((Condition)javaSourceQuery).perform((Operation)new IndexJavaFileIterationOperator());
    }

    private final class IndexJavaFileIterationOperator
    extends AbstractIterationOperation<FileModel> {
        private static final int JAVA_SUFFIX_LEN = 5;

        private IndexJavaFileIterationOperator() {
        }

        public void perform(GraphRewrite event, EvaluationContext context, FileModel payload) {
            TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
            GraphContext graphContext = event.getGraphContext();
            WindupConfigurationModel configuration = (WindupConfigurationModel)new GraphService(graphContext, WindupConfigurationModel.class).getUnique();
            String inputDir = configuration.getInputPath().getFilePath();
            inputDir = Paths.get(inputDir, new String[0]).toAbsolutePath().toString();
            String filepath = payload.getFilePath();
            if (!(filepath = Paths.get(filepath, new String[0]).toAbsolutePath().toString()).startsWith(inputDir)) {
                return;
            }
            String classFilePath = filepath.substring(inputDir.length() + 1);
            String qualifiedName = classFilePath.replace(File.separatorChar, '.').substring(0, classFilePath.length() - 5);
            String packageName = "";
            if (qualifiedName.contains(".")) {
                packageName = qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
            }
            if (packageName.startsWith("src.main.java.")) {
                packageName = packageName.substring("src.main.java.".length());
            }
            JavaSourceFileModel javaFileModel = (JavaSourceFileModel)GraphService.addTypeToModel((GraphContext)graphContext, (WindupVertexFrame)payload, JavaSourceFileModel.class);
            technologyTagService.addTagToFileModel((FileModel)javaFileModel, DiscoverJavaFilesRuleProvider.TECH_TAG, TECH_TAG_LEVEL);
            javaFileModel.setPackageName(packageName);
            try (FileInputStream fis = new FileInputStream(payload.getFilePath());){
                this.addParsedClassToFile(fis, event.getGraphContext(), javaFileModel);
            }
            catch (FileNotFoundException e) {
                throw new WindupException("File in " + payload.getFilePath() + " was not found.", (Throwable)e);
            }
            catch (IOException e) {
                throw new WindupException("IOException thrown when parsing file located in " + payload.getFilePath(), (Throwable)e);
            }
        }

        private void addParsedClassToFile(FileInputStream fis, GraphContext context, JavaSourceFileModel sourceFileModel) {
            Extendable extendable;
            String superclassName;
            InterfaceCapable interfaceCapable;
            List interfaceNames;
            String qualifiedName;
            JavaSource javaSource;
            try {
                javaSource = (JavaSource)Roaster.parse(JavaSource.class, (InputStream)fis);
            }
            catch (ParserException e) {
                ClassificationService classificationService = new ClassificationService(context);
                classificationService.attachClassification((FileModel)sourceFileModel, "Unparseable Java File", "This Java file could not be parsed");
                return;
            }
            String packageName = javaSource.getPackage();
            sourceFileModel.setPackageName(packageName);
            String simpleName = qualifiedName = javaSource.getQualifiedName();
            if (packageName != null && !packageName.equals("") && simpleName != null) {
                simpleName = simpleName.substring(packageName.length() + 1);
            }
            JavaClassService javaClassService = new JavaClassService(context);
            JavaClassModel javaClassModel = javaClassService.getOrCreate(qualifiedName);
            javaClassModel.setSimpleName(simpleName);
            javaClassModel.setPackageName(packageName);
            javaClassModel.setQualifiedName(qualifiedName);
            javaClassModel.setClassFile(sourceFileModel);
            if (javaSource instanceof InterfaceCapable && (interfaceNames = (interfaceCapable = (InterfaceCapable)javaSource).getInterfaces()) != null) {
                for (String iface : interfaceNames) {
                    JavaClassModel interfaceModel = javaClassService.getOrCreate(iface);
                    javaClassModel.addImplements(interfaceModel);
                }
            }
            if (javaSource instanceof Extendable && Strings.isNullOrEmpty((String)(superclassName = (extendable = (Extendable)javaSource).getSuperType()))) {
                javaClassModel.setExtends(javaClassService.getOrCreate(superclassName));
            }
            sourceFileModel.addJavaClass(javaClassModel);
        }

        public String toString() {
            return "AttachJavaSourceInformationToGraph";
        }
    }
}

