/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.config.operation.iteration;

import java.util.Iterator;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.exception.IllegalTypeArgumentException;
import org.jboss.windup.config.selectors.FramesSelector;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class TypedNamedFramesSelector
implements FramesSelector {
    private final Class<? extends WindupVertexFrame> framesModel;
    private final String varName;

    public TypedNamedFramesSelector(Class<? extends WindupVertexFrame> framesModel, String varName) {
        this.framesModel = framesModel;
        this.varName = varName;
    }

    @Override
    public Iterable<WindupVertexFrame> getFrames(GraphRewrite event, EvaluationContext context) {
        Class<?> actualType;
        Iterable<WindupVertexFrame> frames = Variables.instance(event).findVariable(this.varName);
        Iterator<WindupVertexFrame> it = frames.iterator();
        if (it.hasNext() && !this.framesModel.isAssignableFrom(actualType = it.next().getClass())) {
            throw new IllegalTypeArgumentException(this.varName, this.framesModel, actualType);
        }
        return frames;
    }
}

