/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ImplicitNullAnnotationVerifier {
    ImplicitNullAnnotationVerifier buddyImplicitNullAnnotationsVerifier;
    private boolean inheritNullAnnotations;

    public ImplicitNullAnnotationVerifier(boolean inheritNullAnnotations) {
        this.buddyImplicitNullAnnotationsVerifier = this;
        this.inheritNullAnnotations = inheritNullAnnotations;
    }

    ImplicitNullAnnotationVerifier(CompilerOptions options) {
        this.buddyImplicitNullAnnotationsVerifier = new ImplicitNullAnnotationVerifier(options.inheritNullAnnotations);
        this.inheritNullAnnotations = options.inheritNullAnnotations;
    }

    public void checkImplicitNullAnnotations(MethodBinding currentMethod, AbstractMethodDeclaration srcMethod, boolean complain, Scope scope) {
        try {
            ReferenceBinding currentType = currentMethod.declaringClass;
            if (currentType.id == 1) {
                return;
            }
            boolean needToApplyNonNullDefault = currentMethod.hasNonNullDefault();
            boolean isInstanceMethod = !currentMethod.isConstructor() && !currentMethod.isStatic();
            if (!(needToApplyNonNullDefault || (complain &= isInstanceMethod) || this.inheritNullAnnotations && isInstanceMethod)) {
                return;
            }
            if (isInstanceMethod) {
                int length;
                ArrayList superMethodList = new ArrayList();
                int paramLen = currentMethod.parameters.length;
                this.findAllOverriddenMethods(currentMethod.original(), currentMethod.selector, paramLen, currentType, new HashSet(), superMethodList);
                InheritedNonNullnessInfo[] inheritedNonNullnessInfos = new InheritedNonNullnessInfo[paramLen + 1];
                int i = 0;
                while (i < paramLen + 1) {
                    inheritedNonNullnessInfos[i] = new InheritedNonNullnessInfo();
                    ++i;
                }
                int i2 = length = superMethodList.size();
                while (--i2 >= 0) {
                    MethodBinding currentSuper = (MethodBinding)superMethodList.get(i2);
                    if ((currentSuper.tagBits & 0x1000L) == 0L) {
                        this.checkImplicitNullAnnotations(currentSuper, null, false, scope);
                    }
                    this.checkNullSpecInheritance(currentMethod, srcMethod, needToApplyNonNullDefault, complain, currentSuper, scope, inheritedNonNullnessInfos);
                    needToApplyNonNullDefault = false;
                }
                InheritedNonNullnessInfo info = inheritedNonNullnessInfos[0];
                if (!info.complained) {
                    if (info.inheritedNonNullness == Boolean.TRUE) {
                        currentMethod.tagBits |= 0x100000000000000L;
                    } else if (info.inheritedNonNullness == Boolean.FALSE) {
                        currentMethod.tagBits |= 0x80000000000000L;
                    }
                }
                int i3 = 0;
                while (i3 < paramLen) {
                    info = inheritedNonNullnessInfos[i3 + 1];
                    if (!info.complained && info.inheritedNonNullness != null) {
                        Argument currentArg = srcMethod == null ? null : srcMethod.arguments[i3];
                        this.recordArgNonNullness(currentMethod, paramLen, i3, currentArg, info.inheritedNonNullness);
                    }
                    ++i3;
                }
            }
            if (needToApplyNonNullDefault) {
                currentMethod.fillInDefaultNonNullness(srcMethod);
            }
        }
        finally {
            currentMethod.tagBits |= 0x1000L;
        }
    }

    private void findAllOverriddenMethods(MethodBinding original, char[] selector, int suggestedParameterLength, ReferenceBinding currentType, Set ifcsSeen, List result) {
        if (currentType.id == 1) {
            return;
        }
        this.collectOverriddenMethods(original, selector, suggestedParameterLength, currentType.superclass(), ifcsSeen, result);
        ReferenceBinding[] superInterfaces = currentType.superInterfaces();
        int ifcLen = superInterfaces.length;
        int i = 0;
        while (i < ifcLen) {
            ReferenceBinding currentIfc = superInterfaces[i];
            if (ifcsSeen.add(currentIfc.original())) {
                this.collectOverriddenMethods(original, selector, suggestedParameterLength, currentIfc, ifcsSeen, result);
            }
            ++i;
        }
    }

    private void collectOverriddenMethods(MethodBinding original, char[] selector, int suggestedParameterLength, ReferenceBinding superType, Set ifcsSeen, List result) {
        MethodBinding[] ifcMethods = superType.getMethods(selector, suggestedParameterLength);
        int length = ifcMethods.length;
        int i = 0;
        while (i < length) {
            MethodBinding currentMethod = ifcMethods[i];
            if (!currentMethod.isStatic() && this.areParametersEqual(original, currentMethod.original())) {
                result.add(currentMethod);
                return;
            }
            ++i;
        }
        this.findAllOverriddenMethods(original, selector, suggestedParameterLength, superType, ifcsSeen, result);
    }

    /*
     * Unable to fully structure code
     */
    void checkNullSpecInheritance(MethodBinding currentMethod, AbstractMethodDeclaration srcMethod, boolean hasNonNullDefault, boolean shouldComplain, MethodBinding inheritedMethod, Scope scope, InheritedNonNullnessInfo[] inheritedNonNullnessInfos) {
        block33: {
            if ((inheritedMethod.tagBits & 4096L) == 0L) {
                this.buddyImplicitNullAnnotationsVerifier.checkImplicitNullAnnotations(inheritedMethod, null, false, scope);
            }
            inheritedBits = inheritedMethod.tagBits;
            inheritedNullnessBits = inheritedBits & 0x180000000000000L;
            currentBits = currentMethod.tagBits;
            currentNullnessBits = currentBits & 0x180000000000000L;
            environment = scope.environment();
            shouldInherit = this.inheritNullAnnotations;
            if (currentMethod.returnType == null || currentMethod.returnType.isBaseType()) break block33;
            if (currentNullnessBits != 0L) ** GOTO lbl22
            if (shouldInherit && inheritedNullnessBits != 0L) {
                if (hasNonNullDefault && shouldComplain && inheritedNullnessBits == 0x80000000000000L) {
                    scope.problemReporter().conflictingNullAnnotations(currentMethod, ((MethodDeclaration)srcMethod).returnType, inheritedMethod);
                }
                if (inheritedNonNullnessInfos != null && srcMethod != null) {
                    this.recordDeferredInheritedNullness(scope, ((MethodDeclaration)srcMethod).returnType, inheritedMethod, inheritedNullnessBits == 0x100000000000000L, inheritedNonNullnessInfos[0]);
                } else {
                    currentMethod.tagBits |= inheritedNullnessBits;
                }
            } else {
                if (hasNonNullDefault) {
                    currentNullnessBits = 0x100000000000000L;
                    currentMethod.tagBits |= 0x100000000000000L;
                }
lbl22:
                // 4 sources

                if (shouldComplain && (inheritedNullnessBits & 0x100000000000000L) != 0L && currentNullnessBits != 0x100000000000000L) {
                    if (srcMethod != null) {
                        scope.problemReporter().illegalReturnRedefinition(srcMethod, inheritedMethod, environment.getNonNullAnnotationName());
                    } else {
                        scope.problemReporter().cannotImplementIncompatibleNullness(currentMethod, inheritedMethod);
                        return;
                    }
                }
            }
        }
        currentArguments = srcMethod == null ? null : srcMethod.arguments;
        length = 0;
        if (currentArguments != null) {
            length = currentArguments.length;
        } else if (inheritedMethod.parameterNonNullness != null) {
            length = inheritedMethod.parameterNonNullness.length;
        } else if (currentMethod.parameterNonNullness != null) {
            length = currentMethod.parameterNonNullness.length;
        }
        i = 0;
        while (i < length) {
            block34: {
                if (currentMethod.parameters[i].isBaseType()) break block34;
                currentArgument = currentArguments == null ? null : currentArguments[i];
                inheritedNonNullNess = inheritedMethod.parameterNonNullness == null ? null : inheritedMethod.parameterNonNullness[i];
                v0 = currentNonNullNess = currentMethod.parameterNonNullness == null ? null : currentMethod.parameterNonNullness[i];
                if (currentNonNullNess != null) ** GOTO lbl57
                if (inheritedNonNullNess != null && shouldInherit) {
                    if (hasNonNullDefault && shouldComplain && inheritedNonNullNess == Boolean.FALSE && currentArgument != null) {
                        scope.problemReporter().conflictingNullAnnotations(currentMethod, currentArgument, inheritedMethod);
                    }
                    if (inheritedNonNullnessInfos != null && srcMethod != null) {
                        this.recordDeferredInheritedNullness(scope, srcMethod.arguments[i].type, inheritedMethod, inheritedNonNullNess, inheritedNonNullnessInfos[i + 1]);
                    } else {
                        this.recordArgNonNullness(currentMethod, length, i, currentArgument, inheritedNonNullNess);
                    }
                } else {
                    if (hasNonNullDefault) {
                        currentNonNullNess = Boolean.TRUE;
                        this.recordArgNonNullness(currentMethod, length, i, currentArgument, Boolean.TRUE);
                    }
lbl57:
                    // 4 sources

                    if (shouldComplain) {
                        annotationName = inheritedNonNullNess == Boolean.TRUE ? environment.getNonNullAnnotationName() : environment.getNullableAnnotationName();
                        if (inheritedNonNullNess != Boolean.TRUE && currentNonNullNess == Boolean.TRUE) {
                            if (currentArgument != null) {
                                scope.problemReporter().illegalRedefinitionToNonNullParameter(currentArgument, inheritedMethod.declaringClass, inheritedNonNullNess == null ? null : environment.getNullableAnnotationName());
                            } else {
                                scope.problemReporter().cannotImplementIncompatibleNullness(currentMethod, inheritedMethod);
                            }
                        } else if (currentNonNullNess == null) {
                            if (inheritedNonNullNess == Boolean.FALSE) {
                                if (currentArgument != null) {
                                    scope.problemReporter().parameterLackingNullableAnnotation(currentArgument, inheritedMethod.declaringClass, annotationName);
                                } else {
                                    scope.problemReporter().cannotImplementIncompatibleNullness(currentMethod, inheritedMethod);
                                }
                            } else if (inheritedNonNullNess == Boolean.TRUE) {
                                scope.problemReporter().parameterLackingNonnullAnnotation(currentArgument, inheritedMethod.declaringClass, annotationName);
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected void recordDeferredInheritedNullness(Scope scope, ASTNode location, MethodBinding inheritedMethod, Boolean inheritedNonNullness, InheritedNonNullnessInfo nullnessInfo) {
        if (nullnessInfo.inheritedNonNullness != null && nullnessInfo.inheritedNonNullness != inheritedNonNullness) {
            scope.problemReporter().conflictingInheritedNullAnnotations(location, nullnessInfo.inheritedNonNullness, nullnessInfo.annotationOrigin, inheritedNonNullness, inheritedMethod);
            nullnessInfo.complained = true;
        } else {
            nullnessInfo.inheritedNonNullness = inheritedNonNullness;
            nullnessInfo.annotationOrigin = inheritedMethod;
        }
    }

    void recordArgNonNullness(MethodBinding method, int paramCount, int paramIdx, Argument currentArgument, Boolean nonNullNess) {
        if (method.parameterNonNullness == null) {
            method.parameterNonNullness = new Boolean[paramCount];
        }
        method.parameterNonNullness[paramIdx] = nonNullNess;
        if (currentArgument != null) {
            currentArgument.binding.tagBits = currentArgument.binding.tagBits | (nonNullNess != false ? 0x100000000000000L : 0x80000000000000L);
        }
    }

    boolean areParametersEqual(MethodBinding one, MethodBinding two) {
        TypeBinding[] oneArgs = one.parameters;
        TypeBinding[] twoArgs = two.parameters;
        if (oneArgs == twoArgs) {
            return true;
        }
        int length = oneArgs.length;
        if (length != twoArgs.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!this.areTypesEqual(oneArgs[i], twoArgs[i])) {
                if (oneArgs[i].leafComponentType().isRawType() && oneArgs[i].dimensions() == twoArgs[i].dimensions() && oneArgs[i].leafComponentType().isEquivalentTo(twoArgs[i].leafComponentType())) {
                    if (one.typeVariables != Binding.NO_TYPE_VARIABLES) {
                        return false;
                    }
                    int j = 0;
                    while (j < i) {
                        if (oneArgs[j].leafComponentType().isParameterizedTypeWithActualArguments()) {
                            return false;
                        }
                        ++j;
                    }
                    break;
                }
                return false;
            }
            ++i;
        }
        ++i;
        while (i < length) {
            if (!this.areTypesEqual(oneArgs[i], twoArgs[i])) {
                if (!oneArgs[i].leafComponentType().isRawType() || oneArgs[i].dimensions() != twoArgs[i].dimensions() || !oneArgs[i].leafComponentType().isEquivalentTo(twoArgs[i].leafComponentType())) {
                    return false;
                }
            } else if (oneArgs[i].leafComponentType().isParameterizedTypeWithActualArguments()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean areTypesEqual(TypeBinding one, TypeBinding two) {
        if (one == two) {
            return true;
        }
        switch (one.kind()) {
            case 4: {
                switch (two.kind()) {
                    case 260: 
                    case 1028: {
                        if (one != two.erasure()) break;
                        return true;
                    }
                }
                break;
            }
            case 260: 
            case 1028: {
                switch (two.kind()) {
                    case 4: {
                        if (one.erasure() != two) break;
                        return true;
                    }
                }
                break;
            }
        }
        if (one.isParameterizedType() && two.isParameterizedType()) {
            return one.isEquivalentTo(two) && two.isEquivalentTo(one);
        }
        return false;
    }

    static class InheritedNonNullnessInfo {
        Boolean inheritedNonNullness;
        MethodBinding annotationOrigin;
        boolean complained;

        InheritedNonNullnessInfo() {
        }
    }
}

