/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AST;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Block;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Modifier;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SimpleName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Statement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TypeParameter;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.VariableDeclaration;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.TypeVariable;
import org.jboss.forge.roaster.model.Visibility;
import org.jboss.forge.roaster.model.VisibilityScoped;
import org.jboss.forge.roaster.model.ast.AnnotationAccessor;
import org.jboss.forge.roaster.model.ast.ModifierAccessor;
import org.jboss.forge.roaster.model.impl.ParameterImpl;
import org.jboss.forge.roaster.model.impl.TypeImpl;
import org.jboss.forge.roaster.model.impl.TypeVariableImpl;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.AnnotationTargetSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;
import org.jboss.forge.roaster.model.source.TypeVariableSource;
import org.jboss.forge.roaster.model.source.VisibilityScopedSource;
import org.jboss.forge.roaster.model.util.Strings;
import org.jboss.forge.roaster.model.util.Types;

public class MethodImpl<O extends JavaSource<O>>
implements MethodSource<O> {
    private final AnnotationAccessor<O, MethodSource<O>> annotations = new AnnotationAccessor();
    private final ModifierAccessor modifiers = new ModifierAccessor();
    private O parent = null;
    private AST ast = null;
    private CompilationUnit cu = null;
    private final MethodDeclaration method;

    private void init(O parent) {
        this.parent = parent;
        this.cu = (CompilationUnit)parent.getInternal();
        this.ast = this.cu.getAST();
    }

    public MethodImpl(O parent) {
        this.init(parent);
        this.method = this.ast.newMethodDeclaration();
        this.method.setConstructor(false);
    }

    public MethodImpl(O parent, Object internal) {
        this.init(parent);
        this.method = (MethodDeclaration)internal;
    }

    public MethodImpl(O parent, String method) {
        MethodDeclaration subtree;
        this.init(parent);
        String stub = "public class Stub { " + method + " }";
        JavaClassSource temp = (JavaClassSource)Roaster.parse((String)stub);
        List methods = temp.getMethods();
        MethodDeclaration newMethod = (MethodDeclaration)((MethodSource)methods.get(0)).getInternal();
        this.method = subtree = (MethodDeclaration)ASTNode.copySubtree(this.cu.getAST(), newMethod);
    }

    public String toSignature() {
        String signature = (Visibility.PACKAGE_PRIVATE.equals((Object)this.getVisibility().scope()) ? "" : this.getVisibility().scope()) + " ";
        signature = signature + this.getName() + "(";
        List<ParameterSource<O>> parameters = this.getParameters();
        for (ParameterSource<O> p : parameters) {
            signature = signature + p.getType().getName();
            if (parameters.indexOf(p) >= parameters.size() - 1) continue;
            signature = signature + ", ";
        }
        signature = signature + ") : " + (this.getReturnType() == null ? "void" : this.getReturnType().getName());
        return signature;
    }

    public AnnotationSource<O> addAnnotation() {
        return this.annotations.addAnnotation((AnnotationTargetSource<O, MethodSource<O>>)this, this.method);
    }

    public AnnotationSource<O> addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        if (!this.parent.hasImport(clazz)) {
            this.parent.addImport(clazz);
        }
        return this.annotations.addAnnotation((AnnotationTargetSource<O, MethodSource<O>>)this, (ASTNode)this.method, clazz.getSimpleName());
    }

    public AnnotationSource<O> addAnnotation(String className) {
        return this.annotations.addAnnotation((AnnotationTargetSource<O, MethodSource<O>>)this, (ASTNode)this.method, className);
    }

    public List<AnnotationSource<O>> getAnnotations() {
        return this.annotations.getAnnotations((AnnotationTargetSource<O, MethodSource<O>>)this, this.method);
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.hasAnnotation(this, this.method, type.getName());
    }

    public boolean hasAnnotation(String type) {
        return this.annotations.hasAnnotation(this, this.method, type);
    }

    public MethodSource<O> removeAnnotation(Annotation<O> annotation) {
        return this.annotations.removeAnnotation(this, this.method, annotation);
    }

    public AnnotationSource<O> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<O, MethodSource<O>>)this, (ASTNode)this.method, (Class<java.lang.annotation.Annotation>)type);
    }

    public AnnotationSource<O> getAnnotation(String type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<O, MethodSource<O>>)this, (ASTNode)this.method, type);
    }

    public String getBody() {
        String result = "";
        List statements = (List)this.method.getBody().getStructuralProperty(Block.STATEMENTS_PROPERTY);
        for (Statement statement : statements) {
            result = result + statement + " ";
        }
        return result;
    }

    public MethodSource<O> setBody(String body) {
        String stub = "public class Stub { public void method() {" + body + "} }";
        JavaClassSource temp = (JavaClassSource)Roaster.parse((String)stub);
        List methods = temp.getMethods();
        Block block = ((MethodDeclaration)((MethodSource)methods.get(0)).getInternal()).getBody();
        block = (Block)ASTNode.copySubtree(this.method.getAST(), block);
        this.method.setBody(block);
        return this;
    }

    public MethodSource<O> setConstructor(boolean constructor) {
        this.method.setConstructor(constructor);
        if (this.isConstructor()) {
            this.method.setName(this.ast.newSimpleName(this.parent.getName()));
        }
        return this;
    }

    public boolean isConstructor() {
        return this.method.isConstructor();
    }

    public Type<O> getReturnType() {
        if (this.isConstructor()) {
            return null;
        }
        return new TypeImpl<O>(this.parent, this.method.getReturnType2());
    }

    public boolean isReturnTypeVoid() {
        return this.getReturnType() == null || this.getReturnType().isType(Void.TYPE);
    }

    public MethodSource<O> setReturnType(Class<?> type) {
        return this.setReturnType(type.getSimpleName());
    }

    public MethodSource<O> setReturnTypeVoid() {
        return this.setReturnType(Void.TYPE);
    }

    public MethodSource<O> setReturnType(String typeName) {
        String stub = "public class Stub { public " + typeName + " method() {} }";
        JavaClassSource temp = (JavaClassSource)Roaster.parse((String)stub);
        List methods = temp.getMethods();
        org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type returnType = ((MethodDeclaration)((MethodSource)methods.get(0)).getInternal()).getReturnType2();
        returnType = (org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type)ASTNode.copySubtree(this.method.getAST(), returnType);
        this.method.setReturnType2(returnType);
        return this;
    }

    public MethodSource<O> setReturnType(JavaType<?> type) {
        return this.setReturnType(type.getName());
    }

    public boolean isAbstract() {
        return this.modifiers.hasModifier(this.method, Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
    }

    public MethodSource<O> setAbstract(boolean abstrct) {
        if (abstrct) {
            this.modifiers.addModifier(this.method, Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
        } else {
            this.modifiers.removeModifier(this.method, Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
        }
        return this;
    }

    public boolean isFinal() {
        return this.modifiers.hasModifier(this.method, Modifier.ModifierKeyword.FINAL_KEYWORD);
    }

    public MethodSource<O> setFinal(boolean finl) {
        if (finl) {
            this.modifiers.addModifier(this.method, Modifier.ModifierKeyword.FINAL_KEYWORD);
        } else {
            this.modifiers.removeModifier(this.method, Modifier.ModifierKeyword.FINAL_KEYWORD);
        }
        return this;
    }

    public boolean isStatic() {
        return this.modifiers.hasModifier(this.method, Modifier.ModifierKeyword.STATIC_KEYWORD);
    }

    public MethodSource<O> setStatic(boolean statc) {
        if (statc) {
            this.modifiers.addModifier(this.method, Modifier.ModifierKeyword.STATIC_KEYWORD);
        } else {
            this.modifiers.removeModifier(this.method, Modifier.ModifierKeyword.STATIC_KEYWORD);
        }
        return this;
    }

    public String getName() {
        return this.method.getName().getFullyQualifiedName();
    }

    public MethodSource<O> setName(String name) {
        if (this.method.isConstructor()) {
            throw new IllegalStateException("Cannot set the name of a constructor.");
        }
        this.method.setName(this.ast.newSimpleName(name));
        return this;
    }

    public MethodSource<O> setParameters(String parameters) {
        String stub = "public class Stub { public void method( " + parameters + " ) {} }";
        JavaClassSource temp = (JavaClassSource)Roaster.parse((String)stub);
        List methods = temp.getMethods();
        List astParameters = ((MethodDeclaration)((MethodSource)methods.get(0)).getInternal()).parameters();
        this.method.parameters().clear();
        for (VariableDeclaration declaration : astParameters) {
            VariableDeclaration copy = (VariableDeclaration)ASTNode.copySubtree(this.method.getAST(), declaration);
            this.method.parameters().add(copy);
        }
        return this;
    }

    public List<ParameterSource<O>> getParameters() {
        ArrayList<ParameterImpl<O>> results = new ArrayList<ParameterImpl<O>>();
        List parameters = this.method.parameters();
        for (SingleVariableDeclaration param : parameters) {
            results.add(new ParameterImpl<O>(this.parent, param));
        }
        return Collections.unmodifiableList(results);
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public MethodSource<O> setPackagePrivate() {
        this.modifiers.clearVisibility(this.method);
        return this;
    }

    public boolean isPublic() {
        return this.modifiers.hasModifier(this.method, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    public MethodSource<O> setPublic() {
        this.modifiers.clearVisibility(this.method);
        this.modifiers.addModifier(this.method, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        return this;
    }

    public boolean isPrivate() {
        return this.modifiers.hasModifier(this.method, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
    }

    public MethodSource<O> setPrivate() {
        this.modifiers.clearVisibility(this.method);
        this.modifiers.addModifier(this.method, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        return this;
    }

    public boolean isProtected() {
        return this.modifiers.hasModifier(this.method, Modifier.ModifierKeyword.PROTECTED_KEYWORD);
    }

    public MethodSource<O> setProtected() {
        this.modifiers.clearVisibility(this.method);
        this.modifiers.addModifier(this.method, Modifier.ModifierKeyword.PROTECTED_KEYWORD);
        return this;
    }

    public Visibility getVisibility() {
        return Visibility.getFrom((VisibilityScoped)this);
    }

    public MethodSource<O> setVisibility(Visibility scope) {
        return (MethodSource)Visibility.set((VisibilityScopedSource)this, (Visibility)scope);
    }

    public String toString() {
        return this.method.toString();
    }

    public Object getInternal() {
        return this.method;
    }

    public O getOrigin() {
        return (O)((JavaSource)this.parent.getOrigin());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodImpl other = (MethodImpl)obj;
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    public MethodSource<O> addThrows(Class<? extends Exception> type) {
        return this.addThrows(type.getName());
    }

    public MethodSource<O> addThrows(String type) {
        String packg = Types.getPackage((String)type);
        String name = Types.toSimpleName((String)type);
        if (!packg.isEmpty()) {
            this.getOrigin().addImport(type);
        }
        SimpleName simpleName = this.method.getAST().newSimpleName(name);
        List list = (List)this.method.getStructuralProperty(MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY);
        list.add(simpleName);
        return this;
    }

    public List<String> getThrownExceptions() {
        ArrayList<String> result = new ArrayList<String>();
        List list = (List)this.method.getStructuralProperty(MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY);
        for (Object object : list) {
            result.add(object.toString());
        }
        return result;
    }

    public MethodSource<O> removeThrows(Class<? extends Exception> type) {
        return this.removeThrows(type.getName());
    }

    public MethodSource<O> removeThrows(String type) {
        List list = (List)this.method.getStructuralProperty(MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY);
        for (Object object : list) {
            String thrown = object.toString();
            if (type.equals(thrown)) {
                list.remove(object);
                return this;
            }
            if (!Types.areEquivalent((String)type, (String)thrown)) continue;
            if (!Types.isQualified((String)type) && this.getOrigin().hasImport(thrown)) {
                list.remove(object);
                return this;
            }
            if (!Types.isQualified((String)thrown) && this.getOrigin().hasImport(type)) {
                list.remove(object);
                return this;
            }
            if (this.getOrigin().hasImport(type) || this.getOrigin().hasImport(thrown)) continue;
            list.remove(object);
            return this;
        }
        return this;
    }

    public List<TypeVariableSource<O>> getTypeVariables() {
        ArrayList<TypeVariableImpl<O>> result = new ArrayList<TypeVariableImpl<O>>();
        List typeParameters = this.method.typeParameters();
        if (typeParameters != null) {
            for (TypeParameter typeParameter : typeParameters) {
                result.add(new TypeVariableImpl<O>(this.parent, typeParameter));
            }
        }
        return Collections.unmodifiableList(result);
    }

    public TypeVariableSource<O> getTypeVariable(String name) {
        List typeParameters = this.method.typeParameters();
        for (TypeParameter typeParameter : typeParameters) {
            if (!Strings.areEqual((String)name, (String)typeParameter.getName().getIdentifier())) continue;
            return new TypeVariableImpl<O>(this.parent, typeParameter);
        }
        return null;
    }

    public TypeVariableSource<O> addTypeVariable() {
        TypeParameter tp2 = this.method.getAST().newTypeParameter();
        this.method.typeParameters().add(tp2);
        return new TypeVariableImpl<O>(this.parent, tp2);
    }

    public TypeVariableSource<O> addTypeVariable(String name) {
        return (TypeVariableSource)this.addTypeVariable().setName(name);
    }

    public MethodSource<O> removeTypeVariable(String name) {
        List typeParameters = this.method.typeParameters();
        Iterator iter = typeParameters.iterator();
        while (iter.hasNext()) {
            if (!Strings.areEqual((String)name, (String)((TypeParameter)iter.next()).getName().getIdentifier())) continue;
            iter.remove();
            break;
        }
        return this;
    }

    public MethodSource<O> removeTypeVariable(TypeVariable<?> typeVariable) {
        return this.removeTypeVariable(typeVariable.getName());
    }

    public ParameterSource<O> addParameter(Class<?> type, String name) {
        return this.addParameter(type.getName(), name);
    }

    public ParameterSource<O> addParameter(JavaType<?> type, String name) {
        return this.addParameter(type.getQualifiedName(), name);
    }

    public ParameterSource<O> addParameter(String type, String name) {
        this.getOrigin().addImport(type);
        String stub = "public class Stub { public void method( " + Types.toSimpleName((String)type) + " " + name + " ) {} }";
        JavaClassSource temp = (JavaClassSource)Roaster.parse((String)stub);
        List methods = temp.getMethods();
        List astParameters = ((MethodDeclaration)((MethodSource)methods.get(0)).getInternal()).parameters();
        ParameterImpl<O> param = null;
        for (VariableDeclaration declaration : astParameters) {
            VariableDeclaration copy = (VariableDeclaration)ASTNode.copySubtree(this.method.getAST(), declaration);
            this.method.parameters().add(copy);
            param = new ParameterImpl<O>(this.parent, copy);
        }
        return param;
    }

    public MethodSource<O> removeParameter(ParameterSource<O> parameter) {
        this.method.parameters().remove(parameter.getInternal());
        return this;
    }
}

