/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.configuration.backend;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.configuration.ConcurrentWriteConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ReadConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.util.BackendOperation;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.diskstorage.util.time.ZeroDuration;
import com.thinkaurelius.titan.graphdb.database.serialize.DataOutput;
import com.thinkaurelius.titan.graphdb.database.serialize.StandardSerializer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class KCVSConfiguration
implements ConcurrentWriteConfiguration {
    private final BackendOperation.TransactionalProvider txProvider;
    private final TimestampProvider times;
    private final KeyColumnValueStore store;
    private final String identifier;
    private final StaticBuffer rowKey;
    private final StandardSerializer serializer;
    private Duration maxOperationWaitTime = new StandardDuration(10000L, TimeUnit.MILLISECONDS);

    public KCVSConfiguration(BackendOperation.TransactionalProvider txProvider, TimestampProvider times, KeyColumnValueStore store, String identifier) throws BackendException {
        Preconditions.checkArgument((txProvider != null && store != null && times != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)identifier));
        this.txProvider = txProvider;
        this.times = times;
        this.store = store;
        this.identifier = identifier;
        this.rowKey = this.string2StaticBuffer(this.identifier);
        this.serializer = new StandardSerializer();
    }

    public void setMaxOperationWaitTime(Duration waitTime) {
        Preconditions.checkArgument((ZeroDuration.INSTANCE.compareTo(waitTime) < 0 ? 1 : 0) != 0, (String)"Wait time must be nonnegative: %s", (Object[])new Object[]{waitTime});
        this.maxOperationWaitTime = waitTime;
    }

    @Override
    public <O> O get(String key, Class<O> datatype) {
        StaticBuffer column = this.string2StaticBuffer(key);
        final KeySliceQuery query = new KeySliceQuery(this.rowKey, column, BufferUtil.nextBiggerBuffer(column));
        StaticBuffer result = BackendOperation.execute(new BackendOperation.Transactional<StaticBuffer>(){

            @Override
            public StaticBuffer call(StoreTransaction txh) throws BackendException {
                EntryList entries = KCVSConfiguration.this.store.getSlice(query, txh);
                if (entries.isEmpty()) {
                    return null;
                }
                return ((Entry)entries.get(0)).getValueAs(StaticBuffer.STATIC_FACTORY);
            }

            public String toString() {
                return "getConfiguration";
            }
        }, this.txProvider, this.times, this.maxOperationWaitTime);
        if (result == null) {
            return null;
        }
        return this.staticBuffer2Object(result, datatype);
    }

    @Override
    public <O> void set(String key, O value, O expectedValue) {
        this.set(key, value, expectedValue, true);
    }

    @Override
    public <O> void set(String key, O value) {
        this.set(key, value, null, false);
    }

    public <O> void set(String key, O value, O expectedValue, final boolean checkExpectedValue) {
        ArrayList deletions;
        List<Entry> additions;
        final StaticBuffer column = this.string2StaticBuffer(key);
        if (value != null) {
            additions = new ArrayList<Entry>(1);
            deletions = KeyColumnValueStore.NO_DELETIONS;
            StaticBuffer val = this.object2StaticBuffer(value);
            additions.add(StaticArrayEntry.of(column, val));
        } else {
            additions = KeyColumnValueStore.NO_ADDITIONS;
            deletions = Lists.newArrayList((Object[])new StaticBuffer[]{column});
        }
        final StaticBuffer expectedValueBuffer = checkExpectedValue && expectedValue != null ? this.object2StaticBuffer(expectedValue) : null;
        BackendOperation.execute(new BackendOperation.Transactional<Boolean>(){

            @Override
            public Boolean call(StoreTransaction txh) throws BackendException {
                if (checkExpectedValue) {
                    KCVSConfiguration.this.store.acquireLock(KCVSConfiguration.this.rowKey, column, expectedValueBuffer, txh);
                }
                KCVSConfiguration.this.store.mutate(KCVSConfiguration.this.rowKey, additions, deletions, txh);
                return true;
            }

            public String toString() {
                return "setConfiguration";
            }
        }, this.txProvider, this.times, this.maxOperationWaitTime);
    }

    @Override
    public void remove(String key) {
        this.set(key, null);
    }

    @Override
    public WriteConfiguration copy() {
        throw new UnsupportedOperationException();
    }

    private Map<String, Object> toMap() {
        HashMap entries = Maps.newHashMap();
        List<Entry> result = BackendOperation.execute(new BackendOperation.Transactional<List<Entry>>(){

            @Override
            public List<Entry> call(StoreTransaction txh) throws BackendException {
                return KCVSConfiguration.this.store.getSlice(new KeySliceQuery(KCVSConfiguration.this.rowKey, BufferUtil.zeroBuffer(128), BufferUtil.oneBuffer(128)), txh);
            }

            public String toString() {
                return "setConfiguration";
            }
        }, this.txProvider, this.times, this.maxOperationWaitTime);
        for (Entry entry : result) {
            String key = this.staticBuffer2String(entry.getColumnAs(StaticBuffer.STATIC_FACTORY));
            Object value = this.staticBuffer2Object(entry.getValueAs(StaticBuffer.STATIC_FACTORY), Object.class);
            entries.put(key, value);
        }
        return entries;
    }

    public ReadConfiguration asReadConfiguration() {
        final Map<String, Object> entries = this.toMap();
        return new ReadConfiguration(){

            @Override
            public <O> O get(String key, Class<O> datatype) {
                Preconditions.checkArgument((!entries.containsKey(key) || datatype.isAssignableFrom(entries.get(key).getClass()) ? 1 : 0) != 0);
                return (O)entries.get(key);
            }

            @Override
            public Iterable<String> getKeys(final String prefix) {
                return Lists.newArrayList((Iterable)Iterables.filter(entries.keySet(), (Predicate)new Predicate<String>(){

                    public boolean apply(@Nullable String s) {
                        assert (s != null);
                        return StringUtils.isBlank((String)prefix) || s.startsWith(prefix);
                    }
                }));
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public Iterable<String> getKeys(String prefix) {
        return this.asReadConfiguration().getKeys(prefix);
    }

    @Override
    public void close() {
        try {
            this.store.close();
            this.txProvider.close();
        }
        catch (BackendException e) {
            throw new TitanException("Could not close configuration store", e);
        }
    }

    private StaticBuffer string2StaticBuffer(String s) {
        ByteBuffer out = ByteBuffer.wrap(s.getBytes(Charset.forName("UTF-8")));
        return StaticArrayBuffer.of(out);
    }

    private String staticBuffer2String(StaticBuffer s) {
        return new String(s.as(StaticBuffer.ARRAY_FACTORY), Charset.forName("UTF-8"));
    }

    private <O> StaticBuffer object2StaticBuffer(O value) {
        DataOutput out = this.serializer.getDataOutput(128);
        out.writeClassAndObject(value);
        return out.getStaticBuffer();
    }

    private <O> O staticBuffer2Object(StaticBuffer s, Class<O> datatype) {
        Object value = this.serializer.readClassAndObject(s.asReadBuffer());
        Preconditions.checkArgument((boolean)datatype.isInstance(value), (String)"Could not deserialize to [%s], got: %s", (Object[])new Object[]{datatype, value});
        return (O)value;
    }
}

