/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.log;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.core.attribute.Timestamp;
import com.thinkaurelius.titan.core.log.TransactionRecovery;
import com.thinkaurelius.titan.diskstorage.BackendTransaction;
import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.indexing.IndexTransaction;
import com.thinkaurelius.titan.diskstorage.log.Log;
import com.thinkaurelius.titan.diskstorage.log.Message;
import com.thinkaurelius.titan.diskstorage.log.MessageReader;
import com.thinkaurelius.titan.diskstorage.log.ReadMarker;
import com.thinkaurelius.titan.diskstorage.util.BackendOperation;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import com.thinkaurelius.titan.diskstorage.util.time.StandardTimestamp;
import com.thinkaurelius.titan.diskstorage.util.time.Timepoint;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.database.log.LogTxMeta;
import com.thinkaurelius.titan.graphdb.database.log.LogTxStatus;
import com.thinkaurelius.titan.graphdb.database.log.TransactionLogHeader;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.log.ModificationDeserializer;
import com.thinkaurelius.titan.graphdb.log.StandardTransactionId;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.MixedIndexType;
import com.thinkaurelius.titan.graphdb.types.SchemaSource;
import com.thinkaurelius.titan.graphdb.types.indextype.IndexTypeWrapper;
import com.thinkaurelius.titan.graphdb.types.vertices.TitanSchemaVertex;
import com.thinkaurelius.titan.util.system.BackgroundThread;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTransactionLogProcessor
implements TransactionRecovery {
    private static final Logger logger = LoggerFactory.getLogger(StandardTransactionLogProcessor.class);
    private static final Duration CLEAN_SLEEP_TIME = new StandardDuration(5L, TimeUnit.SECONDS);
    private static final Duration MIN_TX_LENGTH = new StandardDuration(5L, TimeUnit.SECONDS);
    private final StandardTitanGraph graph;
    private final Serializer serializer;
    private final TimestampProvider times;
    private final Log txLog;
    private final Duration persistenceTime;
    private final Duration readTime = new StandardDuration(1L, TimeUnit.SECONDS);
    private final AtomicLong txCounter = new AtomicLong(0L);
    private final BackgroundCleaner cleaner;
    private final AtomicLong successTxCounter = new AtomicLong(0L);
    private final AtomicLong failureTxCounter = new AtomicLong(0L);
    private final Cache<StandardTransactionId, TxEntry> txCache;
    private static final Predicate<IndexType> MIXED_INDEX_FILTER = new Predicate<IndexType>(){

        public boolean apply(@Nullable IndexType indexType) {
            return indexType.isMixedIndex();
        }
    };

    public StandardTransactionLogProcessor(StandardTitanGraph graph, Timestamp startTime) {
        Preconditions.checkArgument((graph != null && graph.isOpen() ? 1 : 0) != 0);
        Preconditions.checkArgument((startTime != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)graph.getConfiguration().hasLogTransactions(), (Object)"Transaction logging must be enabled for recovery to work");
        Duration maxTxLength = graph.getConfiguration().getMaxCommitTime();
        if (maxTxLength.compareTo(MIN_TX_LENGTH) < 0) {
            maxTxLength = MIN_TX_LENGTH;
        }
        Preconditions.checkArgument((maxTxLength != null && !maxTxLength.isZeroLength() ? 1 : 0) != 0, (Object)"Max transaction time cannot be 0");
        this.graph = graph;
        this.serializer = graph.getDataSerializer();
        this.times = graph.getConfiguration().getTimestampProvider();
        this.txLog = graph.getBackend().getSystemTxLog();
        this.persistenceTime = graph.getConfiguration().getMaxWriteTime();
        this.txCache = CacheBuilder.newBuilder().concurrencyLevel(2).initialCapacity(100).expireAfterWrite(maxTxLength.getLength(maxTxLength.getNativeUnit()), maxTxLength.getNativeUnit()).removalListener((RemovalListener)new RemovalListener<StandardTransactionId, TxEntry>(){

            public void onRemoval(RemovalNotification<StandardTransactionId, TxEntry> notification) {
                RemovalCause cause = notification.getCause();
                Preconditions.checkArgument((cause == RemovalCause.EXPIRED ? 1 : 0) != 0, (String)"Unexpected removal cause [%s] for transaction [%s]", (Object[])new Object[]{cause, notification.getKey()});
                TxEntry entry = (TxEntry)notification.getValue();
                if (entry.status == LogTxStatus.SECONDARY_FAILURE || entry.status == LogTxStatus.PRIMARY_SUCCESS) {
                    StandardTransactionLogProcessor.this.failureTxCounter.incrementAndGet();
                    StandardTransactionLogProcessor.this.fixSecondaryFailure((StandardTransactionId)notification.getKey(), entry);
                } else {
                    StandardTransactionLogProcessor.this.successTxCounter.incrementAndGet();
                }
            }
        }).build();
        ReadMarker start = ReadMarker.fromTime(startTime.sinceEpoch(startTime.getNativeUnit()), startTime.getNativeUnit());
        this.txLog.registerReader(start, new TxLogMessageReader());
        this.cleaner = new BackgroundCleaner();
        this.cleaner.start();
    }

    public long[] getStatistics() {
        return new long[]{this.successTxCounter.get(), this.failureTxCounter.get()};
    }

    @Override
    public synchronized void shutdown() throws TitanException {
        this.cleaner.close(CLEAN_SLEEP_TIME.getLength(CLEAN_SLEEP_TIME.getNativeUnit()), CLEAN_SLEEP_TIME.getNativeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixSecondaryFailure(StandardTransactionId txId, TxEntry entry) {
        Predicate isFailedIndex;
        if (entry.entry == null) {
            logger.info("Trying to repair expired or unpersisted transaction [{}] (Ignore in startup)", (Object)txId);
            return;
        }
        boolean userLogFailure = true;
        boolean secIndexFailure = true;
        final TransactionLogHeader.Entry commitEntry = entry.entry;
        final TransactionLogHeader.SecondaryFailures secFail = entry.failures;
        if (secFail != null) {
            userLogFailure = secFail.userLogFailure;
            secIndexFailure = !secFail.failedIndexes.isEmpty();
            isFailedIndex = new Predicate<String>(){

                public boolean apply(@Nullable String s) {
                    return secFail.failedIndexes.contains(s);
                }
            };
        } else {
            isFailedIndex = Predicates.alwaysTrue();
        }
        if (secIndexFailure) {
            HashMultimap indexRestores = HashMultimap.create();
            BackendOperation.execute(new Callable<Boolean>((SetMultimap)indexRestores){
                final /* synthetic */ SetMultimap val$indexRestores;
                {
                    this.val$indexRestores = setMultimap;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call() throws Exception {
                    StandardTitanTx tx = (StandardTitanTx)StandardTransactionLogProcessor.this.graph.newTransaction();
                    try {
                        for (TransactionLogHeader.Modification modification : commitEntry.getContentAsModifications(StandardTransactionLogProcessor.this.serializer)) {
                            InternalRelation rel = ModificationDeserializer.parseRelation(modification, tx);
                            for (MixedIndexType index : StandardTransactionLogProcessor.getMixedIndexes(rel.getType())) {
                                if (index.getElement() != ElementCategory.VERTEX || !isFailedIndex.apply((Object)index.getBackingIndexName())) continue;
                                assert (rel.isProperty());
                                this.val$indexRestores.put((Object)index.getBackingIndexName(), (Object)new IndexRestore(rel.getVertex(0).getLongId(), ElementCategory.VERTEX, StandardTransactionLogProcessor.getIndexId(index)));
                            }
                            for (RelationType relType : rel.getPropertyKeysDirect()) {
                                for (MixedIndexType index : StandardTransactionLogProcessor.getMixedIndexes(relType)) {
                                    if (!index.getElement().isInstance(rel) || !isFailedIndex.apply((Object)index.getBackingIndexName())) continue;
                                    assert (rel.getId() instanceof RelationIdentifier);
                                    this.val$indexRestores.put((Object)index.getBackingIndexName(), (Object)new IndexRestore(rel.getId(), ElementCategory.getByClazz(rel.getClass()), StandardTransactionLogProcessor.getIndexId(index)));
                                }
                            }
                        }
                    }
                    finally {
                        if (tx.isOpen()) {
                            tx.rollback();
                        }
                    }
                    return true;
                }
            }, this.readTime);
            for (String indexName : indexRestores.keySet()) {
                StandardTitanTx tx = (StandardTitanTx)this.graph.newTransaction();
                try {
                    BackendTransaction btx = tx.getTxHandle();
                    IndexTransaction indexTx = btx.getIndexTransaction(indexName);
                    BackendOperation.execute(new Callable<Boolean>((SetMultimap)indexRestores, indexName, tx, indexTx){
                        final /* synthetic */ SetMultimap val$indexRestores;
                        final /* synthetic */ String val$indexName;
                        final /* synthetic */ StandardTitanTx val$tx;
                        final /* synthetic */ IndexTransaction val$indexTx;
                        {
                            this.val$indexRestores = setMultimap;
                            this.val$indexName = string;
                            this.val$tx = standardTitanTx;
                            this.val$indexTx = indexTransaction;
                        }

                        @Override
                        public Boolean call() throws Exception {
                            HashMap restoredDocs = Maps.newHashMap();
                            for (IndexRestore restore : this.val$indexRestores.get((Object)this.val$indexName)) {
                                TitanSchemaVertex indexV = (TitanSchemaVertex)this.val$tx.getVertex(restore.indexId);
                                MixedIndexType index = (MixedIndexType)indexV.asIndexType();
                                TitanElement element = restore.retrieve(this.val$tx);
                                if (element != null) {
                                    StandardTransactionLogProcessor.this.graph.getIndexSerializer().reindexElement(element, index, restoredDocs);
                                    continue;
                                }
                                StandardTransactionLogProcessor.this.graph.getIndexSerializer().removeElement(restore.elementId, index, restoredDocs);
                            }
                            this.val$indexTx.restore(restoredDocs);
                            this.val$indexTx.commit();
                            return true;
                        }

                        public String toString() {
                            return "IndexMutation";
                        }
                    }, this.persistenceTime);
                }
                finally {
                    if (tx.isOpen()) {
                        tx.rollback();
                    }
                }
            }
        }
        final String logTxIdentifier = (String)commitEntry.getMetadata().get((Object)LogTxMeta.LOG_ID);
        if (userLogFailure && logTxIdentifier != null) {
            TransactionLogHeader txHeader = new TransactionLogHeader(this.txCounter.incrementAndGet(), this.times.getTime());
            final StaticBuffer userLogContent = txHeader.serializeUserLog(this.serializer, commitEntry, txId);
            BackendOperation.execute(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    Log userLog = StandardTransactionLogProcessor.this.graph.getBackend().getUserLog(logTxIdentifier);
                    Future<Message> env = userLog.add(userLogContent);
                    if (env.isDone()) {
                        env.get();
                    }
                    return true;
                }
            }, this.persistenceTime);
        }
    }

    private static long getIndexId(IndexType index) {
        SchemaSource base = ((IndexTypeWrapper)index).getSchemaBase();
        assert (base instanceof TitanSchemaVertex);
        return base.getLongId();
    }

    private static Iterable<MixedIndexType> getMixedIndexes(RelationType type) {
        if (!type.isPropertyKey()) {
            return Collections.EMPTY_LIST;
        }
        return Iterables.filter((Iterable)Iterables.filter(((InternalRelationType)type).getKeyIndexes(), MIXED_INDEX_FILTER), MixedIndexType.class);
    }

    private class BackgroundCleaner
    extends BackgroundThread {
        private Timepoint lastInvocation;

        public BackgroundCleaner() {
            super("TxLogProcessorCleanup", false);
            this.lastInvocation = null;
        }

        @Override
        protected void waitCondition() throws InterruptedException {
            if (this.lastInvocation != null) {
                StandardTransactionLogProcessor.this.times.sleepPast(this.lastInvocation.add(CLEAN_SLEEP_TIME));
            }
        }

        @Override
        protected void action() {
            this.lastInvocation = StandardTransactionLogProcessor.this.times.getTime();
            StandardTransactionLogProcessor.this.txCache.cleanUp();
        }

        @Override
        protected void cleanup() {
            StandardTransactionLogProcessor.this.txCache.cleanUp();
        }
    }

    private class TxEntry {
        LogTxStatus status;
        TransactionLogHeader.Entry entry;
        TransactionLogHeader.SecondaryFailures failures;

        private TxEntry() {
        }

        synchronized void update(TransactionLogHeader.Entry e) {
            switch (e.getStatus()) {
                case PRECOMMIT: {
                    this.entry = e;
                    if (this.status != null) break;
                    this.status = LogTxStatus.PRECOMMIT;
                    break;
                }
                case PRIMARY_SUCCESS: {
                    if (this.status != null && this.status != LogTxStatus.PRECOMMIT) break;
                    this.status = LogTxStatus.PRIMARY_SUCCESS;
                    break;
                }
                case COMPLETE_SUCCESS: {
                    if (this.status != null && this.status != LogTxStatus.PRECOMMIT) break;
                    this.status = LogTxStatus.COMPLETE_SUCCESS;
                    break;
                }
                case SECONDARY_SUCCESS: {
                    this.status = LogTxStatus.SECONDARY_SUCCESS;
                    break;
                }
                case SECONDARY_FAILURE: {
                    this.status = LogTxStatus.SECONDARY_FAILURE;
                    this.failures = e.getContentAsSecondaryFailures(StandardTransactionLogProcessor.this.serializer);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected status: " + (Object)((Object)e.getStatus())));
                }
            }
        }
    }

    private class TxLogMessageReader
    implements MessageReader {
        private final Callable<TxEntry> entryFactory = new Callable<TxEntry>(){

            @Override
            public TxEntry call() throws Exception {
                return new TxEntry();
            }
        };

        private TxLogMessageReader() {
        }

        @Override
        public void read(Message message) {
            TxEntry entry;
            ReadBuffer content = message.getContent().asReadBuffer();
            String senderId = message.getSenderId();
            TransactionLogHeader.Entry txentry = TransactionLogHeader.parse(content, StandardTransactionLogProcessor.this.serializer, StandardTransactionLogProcessor.this.times);
            TransactionLogHeader txheader = txentry.getHeader();
            StandardTransactionId transactionId = new StandardTransactionId(senderId, txheader.getId(), new StandardTimestamp(txheader.getTimestamp(StandardTransactionLogProcessor.this.times.getUnit()), StandardTransactionLogProcessor.this.times.getUnit()));
            try {
                entry = (TxEntry)StandardTransactionLogProcessor.this.txCache.get((Object)transactionId, this.entryFactory);
            }
            catch (ExecutionException e) {
                throw new AssertionError("Unexpected exception", e);
            }
            entry.update(txentry);
        }
    }

    private static class IndexRestore {
        private final Object elementId;
        private final long indexId;
        private final ElementCategory elementCategory;

        private IndexRestore(Object elementId, ElementCategory category, long indexId) {
            this.elementId = elementId;
            this.indexId = indexId;
            this.elementCategory = category;
        }

        public TitanElement retrieve(TitanTransaction tx) {
            return this.elementCategory.retrieve(this.elementId, tx);
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.elementId).append(this.indexId).toHashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !this.getClass().isInstance(other)) {
                return false;
            }
            IndexRestore r = (IndexRestore)other;
            return r.elementId.equals(this.elementId) && this.indexId == r.indexId;
        }
    }
}

