/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types.system;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.core.attribute.Timestamp;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.diskstorage.EntryMetaData;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import com.thinkaurelius.titan.diskstorage.util.time.StandardTimestamp;
import com.thinkaurelius.titan.graphdb.internal.InternalElement;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.internal.InternalVertexLabel;
import com.thinkaurelius.titan.graphdb.internal.TitanSchemaCategory;
import com.thinkaurelius.titan.graphdb.types.system.BaseRelationType;
import com.thinkaurelius.titan.graphdb.types.system.EmptyRelationType;
import com.thinkaurelius.titan.graphdb.types.system.SystemRelationType;
import com.tinkerpop.blueprints.Direction;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class ImplicitKey
extends EmptyRelationType
implements SystemRelationType,
PropertyKey {
    public static final ImplicitKey ID = new ImplicitKey(1001L, "id", Object.class);
    public static final ImplicitKey TITANID = new ImplicitKey(1002L, "$titanid", Long.class);
    public static final ImplicitKey LABEL = new ImplicitKey(11L, "label", String.class);
    public static final ImplicitKey ADJACENT_ID = new ImplicitKey(1003L, "$adjacent", Long.class);
    public static final ImplicitKey TIMESTAMP = new ImplicitKey(5L, "$timestamp", Timestamp.class);
    public static final ImplicitKey VISIBILITY = new ImplicitKey(6L, "$visibility", String.class);
    public static final ImplicitKey TTL = new ImplicitKey(7L, "$ttl", Duration.class);
    public static final Map<EntryMetaData, ImplicitKey> MetaData2ImplicitKey = ImmutableMap.of((Object)((Object)EntryMetaData.TIMESTAMP), (Object)TIMESTAMP, (Object)((Object)EntryMetaData.TTL), (Object)TTL, (Object)((Object)EntryMetaData.VISIBILITY), (Object)VISIBILITY);
    private final Class<?> datatype;
    private final String name;
    private final long id;

    private ImplicitKey(long id, String name, Class<?> datatype) {
        Preconditions.checkArgument((StringUtils.isNotBlank((String)name) && datatype != null && id > 0L ? 1 : 0) != 0);
        this.datatype = datatype;
        this.name = name;
        this.id = BaseRelationType.getSystemTypeId(id, TitanSchemaCategory.PROPERTYKEY);
    }

    public <O> O computeProperty(InternalElement e) {
        if (this == ID) {
            return (O)e.getId();
        }
        if (this == TITANID) {
            return (O)Long.valueOf(e.getLongId());
        }
        if (this == LABEL) {
            if (e instanceof TitanEdge) {
                return (O)((TitanEdge)((Object)e)).getLabel();
            }
            if (e instanceof TitanVertex) {
                return (O)((TitanVertex)((Object)e)).getLabel();
            }
            if (e instanceof TitanProperty) {
                return (O)((TitanProperty)((Object)e)).getPropertyKey().getName();
            }
            return null;
        }
        if (this == TIMESTAMP || this == VISIBILITY) {
            if (e instanceof InternalRelation) {
                InternalRelation r = (InternalRelation)e;
                if (this == VISIBILITY) {
                    return r.getPropertyDirect(this);
                }
                assert (this == TIMESTAMP);
                Long time = (Long)r.getPropertyDirect(this);
                if (time == null) {
                    return null;
                }
                TimeUnit unit = r.tx().getConfiguration().getTimestampProvider().getUnit();
                return (O)new StandardTimestamp(time, unit);
            }
            return null;
        }
        if (this == TTL) {
            int ttl = e instanceof InternalRelation ? ((InternalRelationType)((InternalRelation)e).getType()).getTTL() : (e instanceof InternalVertex ? ((InternalVertexLabel)((InternalVertex)e).getVertexLabel()).getTTL() : 0);
            return (O)new StandardDuration(ttl, TimeUnit.SECONDS);
        }
        throw new AssertionError((Object)("Implicit key property is undefined: " + this.getName()));
    }

    @Override
    public Class<?> getDataType() {
        return this.datatype;
    }

    @Override
    public Cardinality getCardinality() {
        return Cardinality.SINGLE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isPropertyKey() {
        return true;
    }

    @Override
    public boolean isEdgeLabel() {
        return false;
    }

    @Override
    public boolean isHiddenType() {
        return false;
    }

    @Override
    public Multiplicity getMultiplicity() {
        return Multiplicity.convert(this.getCardinality());
    }

    @Override
    public ConsistencyModifier getConsistencyModifier() {
        return ConsistencyModifier.DEFAULT;
    }

    @Override
    public boolean isUnidirected(Direction dir) {
        return dir == Direction.OUT;
    }

    @Override
    public long getLongId() {
        return this.id;
    }

    @Override
    public boolean hasId() {
        return this.id > 0L;
    }

    @Override
    public void setId(long id) {
        throw new IllegalStateException("SystemType has already been assigned an id");
    }

    public String toString() {
        return this.name;
    }
}

