/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.vertices;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.InvalidElementException;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.graphdb.internal.AbstractElement;
import com.thinkaurelius.titan.graphdb.internal.ElementLifeCycle;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.query.vertex.VertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.VertexLabelVertex;
import com.thinkaurelius.titan.graphdb.types.system.BaseKey;
import com.thinkaurelius.titan.graphdb.types.system.BaseLabel;
import com.thinkaurelius.titan.graphdb.types.system.BaseVertexLabel;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.StringFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractVertex
extends AbstractElement
implements InternalVertex {
    private final StandardTitanTx tx;

    protected AbstractVertex(StandardTitanTx tx, long id) {
        super(id);
        assert (tx != null);
        this.tx = tx;
    }

    @Override
    public final InternalVertex it() {
        if (this.tx.isOpen()) {
            return this;
        }
        InternalVertex next = (InternalVertex)this.tx.getNextTx().getVertex(this.getLongId());
        if (next == null) {
            throw InvalidElementException.removedException(this);
        }
        return next;
    }

    @Override
    public final StandardTitanTx tx() {
        return this.tx.isOpen() ? this.tx : this.tx.getNextTx();
    }

    @Override
    public long getCompareId() {
        if (this.tx.isPartitionedVertex(this)) {
            return this.tx.getIdInspector().getCanonicalVertexId(this.getLongId());
        }
        return this.getLongId();
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }

    @Override
    public Object getId() {
        return this.getLongId();
    }

    @Override
    public boolean isModified() {
        return ElementLifeCycle.isModified(this.it().getLifeCycle());
    }

    @Override
    public synchronized void remove() {
        if (this.isRemoved()) {
            throw InvalidElementException.removedException(this);
        }
        Iterator<TitanRelation> iter = ((VertexCentricQueryBuilder)this.it().query().noPartitionRestriction()).relations().iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        for (TitanRelation r : ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.it().query().noPartitionRestriction()).system()).relations()) {
            RelationType t = r.getType();
            assert (t == BaseLabel.VertexLabelEdge || t == BaseKey.VertexExists);
            r.remove();
        }
    }

    @Override
    public String getLabel() {
        return this.getVertexLabel().getName();
    }

    protected Vertex getVertexLabelInternal() {
        return (Vertex)Iterables.getOnlyElement(((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.tx().query(this).noPartitionRestriction()).type(BaseLabel.VertexLabelEdge)).direction(Direction.OUT)).vertices(), null);
    }

    @Override
    public VertexLabel getVertexLabel() {
        Vertex label = this.getVertexLabelInternal();
        if (label == null) {
            return BaseVertexLabel.DEFAULT_VERTEXLABEL;
        }
        return (VertexLabelVertex)label;
    }

    @Override
    public VertexCentricQueryBuilder query() {
        Preconditions.checkArgument((!this.isRemoved() ? 1 : 0) != 0, (String)"Cannot access a removed vertex: %s", (Object[])new Object[]{this});
        return this.tx().query(this);
    }

    public Set<String> getPropertyKeys() {
        HashSet<String> result = new HashSet<String>();
        for (TitanProperty p : this.getProperties()) {
            result.add(p.getPropertyKey().getName());
        }
        return result;
    }

    @Override
    public <O> O getProperty(PropertyKey key) {
        if (!((InternalRelationType)((Object)key)).isHiddenType() && this.tx().getConfiguration().hasPropertyPrefetching()) {
            this.getProperties().iterator().hasNext();
        }
        Iterator<TitanProperty> iter = ((VertexCentricQueryBuilder)this.query().type(key)).properties().iterator();
        if (key.getCardinality() == Cardinality.SINGLE) {
            if (iter.hasNext()) {
                return iter.next().getValue();
            }
            return null;
        }
        ArrayList result = new ArrayList();
        while (iter.hasNext()) {
            result.add(iter.next().getValue());
        }
        return (O)result;
    }

    @Override
    public <O> O getProperty(String key) {
        if (!this.tx().containsRelationType(key)) {
            return null;
        }
        return this.getProperty(this.tx().getPropertyKey(key));
    }

    @Override
    public Iterable<TitanProperty> getProperties() {
        return this.query().properties();
    }

    @Override
    public Iterable<TitanProperty> getProperties(PropertyKey key) {
        return ((VertexCentricQueryBuilder)this.query().type(key)).properties();
    }

    @Override
    public Iterable<TitanProperty> getProperties(String key) {
        return ((VertexCentricQueryBuilder)this.query().keys(key)).properties();
    }

    @Override
    public Iterable<TitanEdge> getEdges() {
        return this.query().titanEdges();
    }

    @Override
    public Iterable<TitanEdge> getTitanEdges(Direction dir, EdgeLabel ... labels) {
        return ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query().direction(dir)).types(labels)).titanEdges();
    }

    @Override
    public Iterable<Edge> getEdges(Direction dir, String ... labels) {
        return ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query().direction(dir)).labels(labels)).edges();
    }

    @Override
    public Iterable<TitanRelation> getRelations() {
        return this.query().relations();
    }

    public Iterable<Vertex> getVertices(Direction direction, String ... labels) {
        return ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query().direction(direction)).labels(labels)).vertices();
    }

    @Override
    public long getPropertyCount() {
        return this.query().propertyCount();
    }

    @Override
    public long getEdgeCount() {
        return this.query().count();
    }

    @Override
    public boolean isConnected() {
        return !Iterables.isEmpty(this.getEdges());
    }

    @Override
    public TitanProperty addProperty(PropertyKey key, Object attribute) {
        return this.tx().addProperty((TitanVertex)this.it(), key, attribute);
    }

    @Override
    public TitanProperty addProperty(String key, Object attribute) {
        return this.tx().addProperty((TitanVertex)this.it(), key, attribute);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.setProperty(this.tx().getPropertyKey(key), value);
    }

    @Override
    public void setProperty(PropertyKey key, Object value) {
        this.tx().setProperty(this.it(), key, value);
    }

    @Override
    public TitanEdge addEdge(EdgeLabel label, TitanVertex vertex) {
        return this.tx().addEdge((TitanVertex)this.it(), vertex, label);
    }

    @Override
    public TitanEdge addEdge(String label, TitanVertex vertex) {
        return this.tx().addEdge((TitanVertex)this.it(), vertex, label);
    }

    public Edge addEdge(String label, Vertex vertex) {
        return this.addEdge(label, (TitanVertex)vertex);
    }

    @Override
    public <O> O removeProperty(RelationType key) {
        assert (key.isPropertyKey());
        O result = null;
        for (TitanProperty p : ((VertexCentricQueryBuilder)this.query().type(key)).properties()) {
            result = p.getValue();
            p.remove();
        }
        return result;
    }

    @Override
    public <O> O removeProperty(String key) {
        if (!this.tx().containsRelationType(key)) {
            return null;
        }
        return this.removeProperty(this.tx().getPropertyKey(key));
    }
}

