/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.discovery.url;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.environment.se.discovery.WeldSEBeanDeploymentArchive;

class BeanArchiveBuilder {
    private Object index;
    private List<String> classes;
    private URL beansXmlUrl;
    private BeansXml beansXml = null;
    private Bootstrap bootstrap;
    private String id;

    public BeanArchiveBuilder(String id, Object index, List<String> classes, URL beansXmlUrl, Bootstrap bootstrap) {
        this.id = id;
        this.index = index;
        this.classes = classes;
        this.beansXmlUrl = beansXmlUrl;
        this.bootstrap = bootstrap;
    }

    public BeansXml parseBeansXml() {
        this.beansXml = this.bootstrap.parse(this.beansXmlUrl);
        return this.beansXml;
    }

    public BeansXml getParsedBeansXml() {
        if (this.beansXml == null) {
            return this.parseBeansXml();
        }
        return this.beansXml;
    }

    public WeldSEBeanDeploymentArchive build() {
        if (this.id == null) {
            throw new IllegalStateException("ID not set");
        }
        return new WeldSEBeanDeploymentArchive(this.id, this.classes, this.getParsedBeansXml());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void clearClasses() {
        this.classes.clear();
    }

    public void removeClass(String className) {
        this.classes.remove(className);
    }

    public Object getIndex() {
        return this.index;
    }

    public List<String> getClasses() {
        return this.classes;
    }

    public URL getBeansXmlUrl() {
        return this.beansXmlUrl;
    }

    public Iterator<String> getClassIterator() {
        return this.classes.iterator();
    }
}

