/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.rdfterm;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class StrDt
implements Function {
    @Override
    public String getURI() {
        return "STRDT";
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 2) {
            throw new ValueExprEvaluationException("STRDT requires 2 arguments, got " + args.length);
        }
        Value lexicalValue = args[0];
        Value datatypeValue = args[1];
        if (QueryEvaluationUtil.isSimpleLiteral(lexicalValue)) {
            Literal lit = (Literal)lexicalValue;
            if (datatypeValue instanceof URI) {
                return valueFactory.createLiteral(lit.getLabel(), (URI)datatypeValue);
            }
            throw new ValueExprEvaluationException("illegal value for operand: " + datatypeValue);
        }
        throw new ValueExprEvaluationException("illegal value for operand: " + lexicalValue);
    }
}

