/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.dependencies;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.eclipse.aether.version.Version;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyException;
import org.jboss.forge.addon.dependencies.DependencyMetadata;
import org.jboss.forge.addon.dependencies.DependencyNode;
import org.jboss.forge.addon.dependencies.DependencyQuery;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.dependencies.builder.DependencyNodeBuilder;
import org.jboss.forge.addon.maven.dependencies.DependencyMetadataImpl;
import org.jboss.forge.addon.maven.util.MavenConvertUtils;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.furnace.manager.maven.MavenContainer;
import org.jboss.forge.furnace.manager.maven.MavenOperationException;
import org.jboss.forge.furnace.manager.maven.util.MavenRepositories;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.forge.furnace.util.Strings;

public class MavenDependencyResolver
implements DependencyResolver {
    private final MavenContainer container;
    private final ResourceFactory factory;

    @Inject
    public MavenDependencyResolver(ResourceFactory factory, MavenContainer container) {
        this.container = container;
        this.factory = factory;
    }

    public Set<Dependency> resolveDependencies(DependencyQuery query) {
        DependencyResult artifacts;
        HashSet<Dependency> result = new HashSet<Dependency>();
        Predicate filter = query.getDependencyFilter();
        RepositorySystem system = this.container.getRepositorySystem();
        Settings settings = this.container.getSettings();
        DefaultRepositorySystemSession session = this.container.setupRepoSession(system, settings);
        Artifact queryArtifact = MavenConvertUtils.coordinateToMavenArtifact(query.getCoordinate());
        List<RemoteRepository> remoteRepos = MavenConvertUtils.convertToMavenRepos(query.getDependencyRepositories(), settings);
        remoteRepos.addAll(MavenRepositories.getRemoteRepositories((MavenContainer)this.container, (Settings)settings));
        CollectRequest collectRequest = new CollectRequest(new org.eclipse.aether.graph.Dependency(queryArtifact, query.getScopeType()), remoteRepos);
        DependencyRequest request = new DependencyRequest(collectRequest, null);
        try {
            artifacts = system.resolveDependencies((RepositorySystemSession)session, request);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Could not resolve dependencies from Query [" + query + "] due to underlying exception", e);
        }
        catch (DependencyResolutionException e) {
            throw new RuntimeException(e);
        }
        org.eclipse.aether.graph.DependencyNode root = artifacts.getRoot();
        for (org.eclipse.aether.graph.DependencyNode node : root.getChildren()) {
            Dependency d = MavenConvertUtils.convertToDependency(this.factory, node);
            if (filter != null && !filter.accept((Object)d)) continue;
            result.add(d);
        }
        return result;
    }

    public List<Coordinate> resolveVersions(DependencyQuery query) {
        VersionRangeResult r = this.getVersions(query);
        ArrayList<Coordinate> result = new ArrayList<Coordinate>();
        Predicate filter = query.getDependencyFilter();
        for (Version v : r.getVersions()) {
            CoordinateBuilder coord = CoordinateBuilder.create((Coordinate)query.getCoordinate()).setVersion(v.toString());
            DependencyBuilder versionedDep = DependencyBuilder.create().setCoordinate((Coordinate)coord);
            if (filter != null && !filter.accept((Object)versionedDep)) continue;
            result.add((Coordinate)coord);
        }
        return result;
    }

    VersionRangeResult getVersions(DependencyQuery query) {
        Coordinate dep = query.getCoordinate();
        try {
            String version = dep.getVersion();
            if (version == null || version.isEmpty()) {
                dep = CoordinateBuilder.create((Coordinate)dep).setVersion("[,)");
            } else if (!version.matches("(\\(|\\[).*?(\\)|\\])")) {
                dep = CoordinateBuilder.create((Coordinate)dep).setVersion("[" + version + "]");
            }
            RepositorySystem maven = this.container.getRepositorySystem();
            Settings settings = this.container.getSettings();
            DefaultRepositorySystemSession session = this.container.setupRepoSession(maven, settings);
            Artifact artifact = MavenConvertUtils.coordinateToMavenArtifact(dep);
            List<RemoteRepository> remoteRepos = MavenConvertUtils.convertToMavenRepos(query.getDependencyRepositories(), settings);
            remoteRepos.addAll(MavenRepositories.getRemoteRepositories((MavenContainer)this.container, (Settings)settings));
            VersionRangeRequest rangeRequest = new VersionRangeRequest(artifact, remoteRepos, null);
            VersionRangeResult rangeResult = maven.resolveVersionRange((RepositorySystemSession)session, rangeRequest);
            return rangeResult;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to look up versions for [" + dep + "]", e);
        }
    }

    public Dependency resolveArtifact(DependencyQuery query) {
        RepositorySystem system = this.container.getRepositorySystem();
        Settings settings = this.container.getSettings();
        List<RemoteRepository> remoteRepos = MavenConvertUtils.convertToMavenRepos(query.getDependencyRepositories(), settings);
        remoteRepos.addAll(MavenRepositories.getRemoteRepositories((MavenContainer)this.container, (Settings)settings));
        DefaultRepositorySystemSession session = this.container.setupRepoSession(system, settings);
        Artifact queryArtifact = MavenConvertUtils.coordinateToMavenArtifact(query.getCoordinate());
        ArtifactRequest request = new ArtifactRequest(queryArtifact, remoteRepos, null);
        try {
            ArtifactResult resolvedArtifact = system.resolveArtifact((RepositorySystemSession)session, request);
            Artifact artifact = resolvedArtifact.getArtifact();
            FileResource artifactResource = (FileResource)this.factory.create(FileResource.class, (Object)artifact.getFile());
            return DependencyBuilder.create().setArtifact(artifactResource).setGroupId(artifact.getGroupId()).setArtifactId(artifact.getArtifactId()).setClassifier(artifact.getClassifier()).setPackaging(artifact.getExtension()).setVersion(artifact.getBaseVersion());
        }
        catch (ArtifactResolutionException e) {
            throw new MavenOperationException((Throwable)e);
        }
    }

    public DependencyNode resolveDependencyHierarchy(final DependencyQuery query) {
        try {
            RepositorySystem system = this.container.getRepositorySystem();
            Settings settings = this.container.getSettings();
            DefaultRepositorySystemSession session = this.container.setupRepoSession(system, settings);
            session.setDependencyTraverser(new DependencyTraverser(){

                public boolean traverseDependency(org.eclipse.aether.graph.Dependency dependency) {
                    if (query.getScopeType() != null) {
                        return query.getScopeType().equals(dependency.getScope());
                    }
                    return !"test".equals(dependency.getScope());
                }

                public DependencyTraverser deriveChildTraverser(DependencyCollectionContext context) {
                    return this;
                }
            });
            session.setDependencySelector((DependencySelector)new ScopeDependencySelector(new String[]{"test"}));
            CoordinateBuilder coord = CoordinateBuilder.create((Coordinate)query.getCoordinate());
            Artifact queryArtifact = MavenConvertUtils.coordinateToMavenArtifact((Coordinate)coord);
            List<RemoteRepository> remoteRepos = MavenConvertUtils.convertToMavenRepos(query.getDependencyRepositories(), settings);
            remoteRepos.addAll(MavenRepositories.getRemoteRepositories((MavenContainer)this.container, (Settings)settings));
            CollectRequest collectRequest = new CollectRequest(new org.eclipse.aether.graph.Dependency(queryArtifact, null), remoteRepos);
            DependencyRequest dr = new DependencyRequest(collectRequest, null);
            DependencyResult result = system.resolveDependencies((RepositorySystemSession)session, dr);
            DependencyNodeBuilder hierarchy = MavenConvertUtils.toDependencyNode(this.factory, null, result.getRoot());
            return hierarchy;
        }
        catch (Exception e) {
            throw new DependencyException("Could not resolve dependencies for addon [" + query.getCoordinate() + "]", (Throwable)e);
        }
    }

    public DependencyMetadata resolveDependencyMetadata(DependencyQuery query) {
        try {
            if (Strings.isNullOrEmpty((String)query.getCoordinate().getVersion())) {
                throw new IllegalArgumentException("Dependency query coordinate version must be specified.");
            }
            RepositorySystem system = this.container.getRepositorySystem();
            Settings settings = this.container.getSettings();
            DefaultRepositorySystemSession session = this.container.setupRepoSession(system, settings);
            Artifact artifact = MavenConvertUtils.coordinateToMavenArtifact(query.getCoordinate());
            List<RemoteRepository> remoteRepos = MavenConvertUtils.convertToMavenRepos(query.getDependencyRepositories(), settings);
            remoteRepos.addAll(MavenRepositories.getRemoteRepositories((MavenContainer)this.container, (Settings)settings));
            ArtifactDescriptorRequest ar = new ArtifactDescriptorRequest(artifact, remoteRepos, null);
            ArtifactDescriptorResult results = system.readArtifactDescriptor((RepositorySystemSession)session, ar);
            Artifact a = results.getArtifact();
            DependencyBuilder d = DependencyBuilder.create().setArtifactId(a.getArtifactId()).setGroupId(a.getGroupId()).setVersion(a.getBaseVersion());
            return new DependencyMetadataImpl((Dependency)d, results);
        }
        catch (Exception e) {
            throw new DependencyException("Unable to resolve any artifacts for query [" + query + "]", (Throwable)e);
        }
    }
}

