/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.convert.impl;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.convert.ConverterGenerator;
import org.jboss.forge.addon.convert.exception.ConverterNotFoundException;
import org.jboss.forge.addon.convert.impl.ConstructorConverter;
import org.jboss.forge.addon.convert.impl.Converters;
import org.jboss.forge.addon.convert.impl.MethodConverter;
import org.jboss.forge.addon.convert.impl.StringToImportedInstanceConverter;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.services.Imported;

@Singleton
public class ConverterFactoryImpl
implements ConverterFactory {
    @Inject
    private AddonRegistry registry;
    private Map<Class<?>, Class<?>> primitiveToWrapperMap = new HashMap();

    public ConverterFactoryImpl() {
        this.primitiveToWrapperMap.put(Boolean.TYPE, Boolean.class);
        this.primitiveToWrapperMap.put(Character.TYPE, Character.class);
        this.primitiveToWrapperMap.put(Byte.TYPE, Byte.class);
        this.primitiveToWrapperMap.put(Short.TYPE, Short.class);
        this.primitiveToWrapperMap.put(Integer.TYPE, Integer.class);
        this.primitiveToWrapperMap.put(Long.TYPE, Long.class);
        this.primitiveToWrapperMap.put(Float.TYPE, Float.class);
        this.primitiveToWrapperMap.put(Double.TYPE, Double.class);
        this.primitiveToWrapperMap.put(Void.TYPE, Void.class);
    }

    public <S, T> Converter<S, T> getConverter(Class<S> source, Class<T> target) {
        Object result = null;
        Imported instances = this.registry.getServices(ConverterGenerator.class);
        for (ConverterGenerator generator : instances) {
            if (!generator.handles(source, target)) continue;
            result = generator.generateConverter(source, target);
            break;
        }
        if (result == null) {
            if (String.class.equals(source) && !this.registry.getServices(target).isUnsatisfied()) {
                result = new StringToImportedInstanceConverter<T>(target, this.registry);
            } else if (String.class.equals(target)) {
                result = Converters.TO_STRING;
            } else if (this.areTypesAssignable(source, target)) {
                result = Converters.NOOP;
            } else {
                Class<Object> targetType = target;
                if (target.isPrimitive()) {
                    targetType = this.primitiveToWrapperMap.get(target);
                }
                try {
                    result = new MethodConverter<S, T>(source, targetType, null, targetType.getMethod("valueOf", source));
                }
                catch (NoSuchMethodException noValueOf) {
                    try {
                        result = new ConstructorConverter<S, Object>(source, targetType, targetType.getConstructor(source));
                    }
                    catch (NoSuchMethodException noConstructor) {
                        throw new ConverterNotFoundException(source, target);
                    }
                }
            }
        }
        return result;
    }

    private boolean areTypesAssignable(Class<?> source, Class<?> target) {
        if (target.isAssignableFrom(source)) {
            return true;
        }
        if (!source.isPrimitive() && !target.isPrimitive()) {
            return false;
        }
        if (source.isPrimitive()) {
            return target == this.primitiveToWrapperMap.get(source);
        }
        return this.primitiveToWrapperMap.get(target) == source;
    }
}

