/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.confighandler;

import java.nio.file.Path;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.rules.apps.xml.operation.xslt.XSLTTransformation;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="xslt", namespace="http://windup.jboss.org/v1/xml")
public class XSLTTransformationHandler
implements ElementHandler<XSLTTransformation> {
    public XSLTTransformation processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String description = JOOX.$((Element)element).attr("description");
        String extension = JOOX.$((Element)element).attr("extension");
        String xsltFile = JOOX.$((Element)element).attr("xsltFile");
        Path pathContainingXml = handlerManager.getXmlInputPath();
        if (pathContainingXml != null) {
            String fullPath = xsltFile.startsWith("/") || xsltFile.startsWith("\\") ? xsltFile : pathContainingXml.resolve(xsltFile).toAbsolutePath().toString();
            return XSLTTransformation.usingFilesystem(fullPath).withDescription(description).withExtension(extension);
        }
        ClassLoader xmlFileAddonClassLoader = handlerManager.getAddonContainingInputXML().getClassLoader();
        return XSLTTransformation.using(xsltFile, xmlFileAddonClassLoader).withDescription(description).withExtension(extension);
    }
}

