/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.forge.addon.parser.java.resources.AbstractJavaMemberResource;
import org.jboss.forge.addon.parser.java.resources.JavaMethodResource;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFacet;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.roaster.model.Method;
import org.jboss.forge.roaster.model.Parameter;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.source.MethodHolderSource;
import org.jboss.forge.roaster.model.util.Strings;

public class JavaMethodResourceImpl
extends AbstractJavaMemberResource<Method>
implements JavaMethodResource {
    private final Method<?, ?> method;

    public JavaMethodResourceImpl(ResourceFactory factory, Resource<?> parent, Method<?, ?> method) {
        super(factory, parent, method);
        this.method = method;
    }

    @Override
    public Resource<Method> createFrom(Method file) {
        throw new RuntimeException("not implemented");
    }

    @Override
    protected List<Resource<?>> doListResources() {
        return Collections.emptyList();
    }

    @Override
    public Method<?, ?> getUnderlyingResourceObject() {
        return this.method;
    }

    @Override
    public String getName() {
        ArrayList<String> parameterTypes = new ArrayList<String>();
        for (Parameter p : this.method.getParameters()) {
            parameterTypes.add(p.getType().getQualifiedName());
        }
        Type methodReturnType = this.method.getReturnType();
        String returnType = this.method.isReturnTypeVoid() || methodReturnType == null ? "void" : methodReturnType.getQualifiedName();
        return String.format("%s(%s)::%s", this.method.getName(), Strings.join(parameterTypes, (String)","), returnType);
    }

    @Override
    public String toString() {
        return this.method.toString();
    }

    public boolean delete() throws UnsupportedOperationException {
        Object origin = this.method.getOrigin();
        if (origin instanceof MethodHolderSource) {
            ((MethodHolderSource)origin).removeMethod(this.method);
            if (!((MethodHolderSource)origin).hasMethodSignature(this.method)) {
                ((JavaResource)this.getParent()).setContents(origin.toString());
                return true;
            }
        }
        return false;
    }

    public boolean delete(boolean recursive) throws UnsupportedOperationException {
        return this.delete();
    }

    public boolean supports(ResourceFacet type) {
        return false;
    }
}

