/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.ui;

import java.io.FileNotFoundException;
import javax.inject.Inject;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.ui.JavaEnumConstantCommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.roaster.model.source.JavaEnumSource;
import org.jboss.forge.roaster.model.source.JavaSource;

public class JavaEnumConstantCommandImpl
extends AbstractProjectCommand
implements JavaEnumConstantCommand {
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    @WithAttributes(label="Enum Class", required=true)
    private UISelectOne<JavaResource> enumClass;
    @Inject
    @WithAttributes(label="Enum Constants", required=true)
    private UIInputMany<String> arguments;

    public void initializeUI(UIBuilder builder) throws Exception {
        UIContext context = builder.getUIContext();
        UISelection initialSelection = context.getInitialSelection();
        Resource resource = (Resource)initialSelection.get();
        if (resource instanceof JavaResource) {
            this.enumClass.setDefaultValue((Object)((JavaResource)resource));
        }
        builder.add(this.enumClass).add(this.arguments);
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Java: New Enum Const").description("Creates a new Java Enum constant").category(Categories.create((String[])new String[]{"Java"}));
    }

    public void validate(UIValidationContext validator) {
        super.validate(validator);
        try {
            if (this.enumClass.hasValue() && !(((JavaResource)this.enumClass.getValue()).getJavaType() instanceof JavaEnumSource)) {
                validator.addValidationError(this.enumClass, "Enum class must be a valid enum");
            }
        }
        catch (FileNotFoundException e) {
            validator.addValidationError(this.enumClass, "Enum specified not found");
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        JavaResource resource = (JavaResource)this.enumClass.getValue();
        JavaEnumSource source = (JavaEnumSource)resource.getJavaType();
        Project project = this.getSelectedProject(context.getUIContext());
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        for (String enumConstant : this.arguments.getValue()) {
            source.addEnumConstant(enumConstant);
        }
        facet.saveJavaSource((JavaSource)source);
        return Results.success();
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }
}

