/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.parser.java.ui;

import javax.inject.Inject;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.parser.java.facets.JavaCompilerFacet;
import org.jboss.forge.addon.parser.java.ui.SetCompilerVersionCommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={JavaCompilerFacet.class})
public class SetCompilerVersionCommandImpl
extends AbstractProjectCommand
implements SetCompilerVersionCommand {
    @Inject
    @WithAttributes(label="Java sources version", required=true)
    private UISelectOne<JavaCompilerFacet.CompilerVersion> sourceVersion;
    @Inject
    @WithAttributes(label="Target compilation version", required=true)
    private UISelectOne<JavaCompilerFacet.CompilerVersion> targetVersion;
    @Inject
    private ProjectFactory projectFactory;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("Project: Set Compiler Version").description("Set the java sources and the target compilation version").category(Categories.create((String[])new String[]{"Project", "Manage"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        JavaCompilerFacet javaCompilerFacet = this.getJavaCompilerFacet(builder.getUIContext());
        this.sourceVersion.setDefaultValue((Object)javaCompilerFacet.getSourceCompilerVersion());
        this.targetVersion.setDefaultValue((Object)javaCompilerFacet.getTargetCompilerVersion());
        builder.add(this.sourceVersion).add(this.targetVersion);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        JavaCompilerFacet facet = this.getJavaCompilerFacet(context.getUIContext());
        facet.setSourceCompilerVersion((JavaCompilerFacet.CompilerVersion)this.sourceVersion.getValue());
        facet.setTargetCompilerVersion((JavaCompilerFacet.CompilerVersion)this.targetVersion.getValue());
        return Results.success();
    }

    private JavaCompilerFacet getJavaCompilerFacet(UIContext context) {
        Project project = this.getSelectedProject(context);
        return (JavaCompilerFacet)project.getFacet(JavaCompilerFacet.class);
    }

    public void validate(UIValidationContext validator) {
        if (this.sourceVersion.getValue() != null && this.targetVersion.getValue() != null && ((JavaCompilerFacet.CompilerVersion)this.sourceVersion.getValue()).ordinal() > ((JavaCompilerFacet.CompilerVersion)this.targetVersion.getValue()).ordinal()) {
            validator.addValidationError(this.sourceVersion, "Selected source version (" + this.sourceVersion.getValue() + ") is higher than the target version (" + this.targetVersion.getValue() + ").");
        }
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }
}

