/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.transform;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.transform.TransformPipe;
import com.tinkerpop.pipes.util.AsPipe;
import com.tinkerpop.pipes.util.PipeHelper;
import com.tinkerpop.pipes.util.structures.Row;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SelectPipe<S>
extends AbstractPipe<S, Row>
implements TransformPipe<S, Row> {
    private final PipeFunction[] stepFunctions;
    private final boolean doFunctions;
    private int currentFunction;
    private final List<AsPipe> asPipes = new ArrayList<AsPipe>();
    private final List<String> columnNames;
    private final Collection<String> stepNames;

    public SelectPipe(Collection<String> stepNames, List<AsPipe> allPreviousAsPipes, PipeFunction ... stepFunctions) {
        this.stepFunctions = stepFunctions;
        this.stepNames = stepNames;
        this.doFunctions = this.stepFunctions.length > 0;
        if (this.doFunctions) {
            this.currentFunction = 0;
        }
        ArrayList<String> tempNames = new ArrayList<String>();
        for (AsPipe asPipe : allPreviousAsPipes) {
            String columnName = asPipe.getName();
            if (null != this.stepNames && !this.stepNames.contains(columnName)) continue;
            tempNames.add(columnName);
            this.asPipes.add(asPipe);
        }
        this.columnNames = tempNames.size() > 0 ? tempNames : null;
    }

    @Override
    public Row processNextStart() {
        this.starts.next();
        Row row = null == this.columnNames ? new Row() : new Row(this.columnNames);
        for (AsPipe asPipe : this.asPipes) {
            if (this.doFunctions) {
                row.add(this.stepFunctions[this.currentFunction++ % this.stepFunctions.length].compute(asPipe.getCurrentEnd()));
                continue;
            }
            row.add(asPipe.getCurrentEnd());
        }
        return row;
    }

    @Override
    public void reset() {
        this.currentFunction = 0;
        super.reset();
    }

    @Override
    public String toString() {
        if (null == this.stepNames) {
            return PipeHelper.makePipeString(this, new Object[0]);
        }
        return PipeHelper.makePipeString(this, this.stepNames.toArray());
    }
}

