/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.result;

import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.result.CompositeResult;
import org.jboss.forge.addon.ui.result.CompositeResultImpl;
import org.jboss.forge.addon.ui.result.Failed;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;

public final class Results {
    public static final Result success() {
        return Results.success(null);
    }

    public static final Result success(String message) {
        return new SuccessfulResult(message);
    }

    public static final Result fail() {
        return Results.fail(null);
    }

    public static final Result fail(String message) {
        return new FailedResult(message);
    }

    public static final Result fail(String message, Throwable e) {
        return new FailedResult(message, e);
    }

    public static final NavigationResult navigateTo(Class<? extends UICommand> next) {
        if (next == null) {
            return null;
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        builder.add(next);
        return builder.build();
    }

    public static final NavigationResult navigateTo(Class<? extends UICommand>[] next) {
        if (next == null) {
            return null;
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        for (Class<? extends UICommand> type : next) {
            builder.add(type);
        }
        return builder.build();
    }

    public static final NavigationResult navigateTo(Class<? extends UICommand> next, Class<? extends UICommand> ... additional) {
        if (next == null) {
            return null;
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        builder.add(next);
        for (Class<? extends UICommand> type : additional) {
            builder.add(type);
        }
        return builder.build();
    }

    public static NavigationResultBuilder navigationBuilder() {
        NavigationResultBuilder builder = NavigationResultBuilder.create();
        return builder;
    }

    public static CompositeResult aggregate(Iterable<Result> results) {
        List<Result> resultList = Results.toList(results);
        return CompositeResultImpl.from(resultList);
    }

    private static <T> List<T> toList(Iterable<T> iterable) {
        if (iterable == null) {
            return null;
        }
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T obj : iterable) {
            list.add(obj);
        }
        return list;
    }

    private static class FailedResult
    implements Result,
    Failed {
        private final String message;
        private Throwable e;

        FailedResult(String message) {
            this.message = message;
        }

        public FailedResult(String message, Throwable e) {
            this.message = message;
            this.e = e;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public Throwable getException() {
            return this.e;
        }

        public String toString() {
            return "Failed [" + this.message + "]";
        }
    }

    private static class SuccessfulResult
    implements Result {
        private final String message;

        SuccessfulResult(String message) {
            this.message = message;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "Success [" + this.message + "]";
        }
    }
}

