/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.result.navigation;

import java.util.ArrayList;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.NavigationResultEntry;
import org.jboss.forge.addon.ui.result.navigation.CompositeCommand;
import org.jboss.forge.furnace.addons.AddonRegistry;

class CompositeNavigationResultEntry
implements NavigationResultEntry {
    private final UICommandMetadata metadata;
    private final Iterable<NavigationResultEntry> entries;
    private UICommand command;

    CompositeNavigationResultEntry(UICommandMetadata metadata, Iterable<NavigationResultEntry> entries) {
        this.metadata = metadata;
        this.entries = entries;
    }

    @Override
    public UICommand getCommand(AddonRegistry addonRegistry, UIContext context) {
        if (this.command == null) {
            ArrayList<UICommand> commands = new ArrayList<UICommand>();
            for (NavigationResultEntry entry : this.entries) {
                UICommand command = entry.getCommand(addonRegistry, context);
                commands.add(command);
            }
            this.command = new CompositeCommand(this.metadata, commands);
        }
        return this.command;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeNavigationResultEntry other = (CompositeNavigationResultEntry)obj;
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }
}

