/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.ui;

import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.shell.Shell;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.ui.context.AbstractUIContext;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextListener;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.util.Selections;

public class ShellContextImpl
extends AbstractUIContext
implements ShellContext {
    private final Shell shell;
    private final UISelection<?> initialSelection;
    private final Iterable<UIContextListener> listeners;

    public ShellContextImpl(Shell shell, Resource<?> currentResource, Iterable<UIContextListener> listeners) {
        this.shell = shell;
        this.initialSelection = Selections.from((Object[])new Resource[]{currentResource});
        this.listeners = listeners;
        this.init();
    }

    public UISelection<?> getInitialSelection() {
        return this.initialSelection;
    }

    public Shell getProvider() {
        return this.shell;
    }

    public void init() {
        for (UIContextListener listener : this.listeners) {
            listener.contextInitialized((UIContext)this);
        }
    }

    public void close() {
        super.close();
        for (UIContextListener listener : this.listeners) {
            listener.contextDestroyed((UIContext)this);
        }
    }

    public boolean isInteractive() {
        Object interactiveFlag = this.getAttributeMap().get("INTERACTIVE");
        return interactiveFlag == null || "true".equalsIgnoreCase(interactiveFlag.toString());
    }

    public boolean isVerbose() {
        Object verboseFlag = this.getAttributeMap().get("VERBOSE");
        return verboseFlag != null && "true".equalsIgnoreCase(verboseFlag.toString());
    }
}

