/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.ui;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.aesh.console.AeshConsole;
import org.jboss.aesh.console.Buffer;
import org.jboss.aesh.console.command.CommandOperation;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.terminal.Key;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.ManyValued;
import org.jboss.forge.addon.ui.input.SelectComponent;
import org.jboss.forge.addon.ui.input.SingleValued;
import org.jboss.forge.addon.ui.input.UIPrompt;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.furnace.util.Lists;
import org.jboss.forge.furnace.util.Strings;

public class ShellUIPromptImpl
implements UIPrompt {
    private final ShellContext context;
    private final AeshConsole console;
    private final ConverterFactory converterFactory;
    private final CommandInvocation commandInvocation;

    public ShellUIPromptImpl(ShellContext context, ConverterFactory converterFactory) {
        this.context = context;
        this.converterFactory = converterFactory;
        this.console = context.getProvider().getConsole();
        this.commandInvocation = (CommandInvocation)context.getAttributeMap().get(CommandInvocation.class);
    }

    public String prompt(String message) {
        if (this.isAcceptDefaultsEnabled()) {
            return null;
        }
        PrintStream out = this.console.getShell().out();
        out.print(message + " ");
        String output = this.readInput(out, true);
        out.println();
        return output;
    }

    public String promptSecret(String message) {
        if (this.isAcceptDefaultsEnabled()) {
            return null;
        }
        PrintStream out = this.console.getShell().out();
        out.print(message + " ");
        String output = this.readInput(out, false);
        out.println();
        return output;
    }

    public boolean promptBoolean(String message) {
        return this.promptBoolean(message, true);
    }

    public boolean promptBoolean(String message, boolean defaultValue) {
        if (this.isAcceptDefaultsEnabled()) {
            return defaultValue;
        }
        String suffix = defaultValue ? " [Y/n] " : " [y/N] ";
        String answer = this.prompt(message + suffix);
        if (Strings.isNullOrEmpty((String)answer)) {
            return defaultValue;
        }
        if (defaultValue) {
            return !"N".equalsIgnoreCase(answer);
        }
        return "Y".equalsIgnoreCase(answer);
    }

    public Object promptValueFrom(InputComponent<?, ?> input) {
        ArrayList<Object> value = null;
        if (input instanceof SingleValued) {
            if (input instanceof SelectComponent) {
                SelectComponent select = (SelectComponent)input;
                value = this.promptSelectComponent(select, Collections.emptyList());
            } else {
                value = this.promptInputComponent(input);
            }
        } else if (input instanceof ManyValued) {
            Object promptValue;
            ArrayList<Object> inputValues = new ArrayList<Object>();
            do {
                if (input instanceof SelectComponent) {
                    SelectComponent select = (SelectComponent)input;
                    promptValue = this.promptSelectComponent(select, inputValues);
                } else {
                    promptValue = this.promptInputComponent(input);
                }
                if (promptValue == null) continue;
                inputValues.add(promptValue);
            } while (promptValue != null);
            if (!inputValues.isEmpty()) {
                value = inputValues;
            }
        }
        InputComponents.setValueFor((ConverterFactory)this.converterFactory, input, (Object)value);
        return input.getValue();
    }

    private Object promptInputComponent(InputComponent<?, ?> input) {
        String label = InputComponents.getLabelFor(input, (boolean)false);
        String description = input.getDescription();
        description = !Strings.isNullOrEmpty((String)description) ? " (" + description + "): " : ": ";
        String inputType = InputComponents.getInputType(input);
        Object value = "org.jboss.forge.inputType.SECRET".equals(inputType) ? this.promptSecret(label + description) : (input.getValueType() == Boolean.class ? Boolean.valueOf(this.promptBoolean(label + description)) : this.prompt(label + description));
        return value;
    }

    private Object promptSelectComponent(SelectComponent select, List<Object> existingItems) {
        int idx;
        if (this.isAcceptDefaultsEnabled()) {
            return select.hasDefaultValue() ? select.getValue() : null;
        }
        PrintStream out = this.console.getShell().out();
        String label = InputComponents.getLabelFor((InputComponent)select, (boolean)false);
        String description = select.getDescription();
        description = !Strings.isNullOrEmpty((String)description) ? " (" + description + "):" : ":";
        Object value = null;
        Converter itemLabelConverter = InputComponents.getItemLabelConverter((ConverterFactory)this.converterFactory, (SelectComponent)select);
        ArrayList items = new ArrayList(Lists.toList((Iterable)select.getValueChoices()));
        items.removeAll(existingItems);
        if (items.isEmpty()) {
            return null;
        }
        out.println();
        for (int i = 0; i < items.size(); ++i) {
            Object item = items.get(i);
            String itemLabel = (String)itemLabelConverter.convert(item);
            out.printf("[%s] - %s", i, itemLabel);
            out.println();
        }
        out.println();
        try {
            idx = Integer.parseInt(this.prompt(label + description + " [0-" + (items.size() - 1) + "]"));
        }
        catch (NumberFormatException nfe) {
            idx = -1;
        }
        if (idx > -1 && idx < items.size()) {
            value = items.get(idx);
        }
        return value;
    }

    private String readInput(PrintStream out, boolean echo) {
        String output;
        try {
            Key inputKey;
            StringBuilder sb = new StringBuilder();
            do {
                CommandOperation input;
                if ((inputKey = (input = this.commandInvocation.getInput()).getInputKey()) == Key.CTRL_C || inputKey == Key.CTRL_D) {
                    return null;
                }
                if (inputKey == Key.BACKSPACE && sb.length() > 0) {
                    sb.setLength(sb.length() - 1);
                    if (!echo) continue;
                    out.print(Buffer.printAnsi((String)"1D"));
                    out.flush();
                    out.print(" ");
                    out.print(Buffer.printAnsi((String)"1D"));
                    out.flush();
                    continue;
                }
                if (!inputKey.isPrintable()) continue;
                if (echo) {
                    out.print(inputKey.getAsChar());
                }
                sb.append(inputKey.getAsChar());
            } while (inputKey != Key.ENTER && inputKey != Key.ENTER_2);
            output = sb.length() == 0 ? null : sb.toString();
        }
        catch (InterruptedException e) {
            output = null;
        }
        return output;
    }

    private boolean isAcceptDefaultsEnabled() {
        if (!this.context.isInteractive()) {
            return true;
        }
        Object acceptDefaultsFlag = this.context.getAttributeMap().get("ACCEPT_DEFAULTS");
        return acceptDefaultsFlag != null && "true".equalsIgnoreCase(acceptDefaultsFlag.toString());
    }
}

