/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.attribute;

import com.thinkaurelius.titan.core.attribute.AttributeSerializer;
import com.thinkaurelius.titan.diskstorage.ScanBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;

public class FloatSerializer
implements AttributeSerializer<Float> {
    @Override
    public void verifyAttribute(Float value) {
    }

    @Override
    public Float convert(Object value) {
        if (value instanceof Number) {
            double d = ((Number)value).doubleValue();
            if (d < -3.4028234663852886E38 || d > 3.4028234663852886E38) {
                throw new IllegalArgumentException("Value too large for float: " + value);
            }
            return Float.valueOf((float)d);
        }
        if (value instanceof String) {
            return Float.valueOf(Float.parseFloat((String)value));
        }
        return null;
    }

    @Override
    public Float read(ScanBuffer buffer) {
        return Float.valueOf(buffer.getFloat());
    }

    @Override
    public void write(WriteBuffer buffer, Float attribute) {
        buffer.putFloat(attribute.floatValue());
    }
}

