/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KryoSerializer {
    private static final int MAX_OUTPUT_SIZE = 0xA00000;
    public static final int KRYO_ID_OFFSET = 50;
    private final boolean registerRequired;
    private final ThreadLocal<Kryo> kryos;
    private final Map<Integer, TypeRegistration> registrations;
    private static final StaticBuffer.Factory<Input> INPUT_FACTORY = new StaticBuffer.Factory<Input>(){

        @Override
        public Input get(byte[] array, int offset, int limit) {
            return new Input(Arrays.copyOfRange(array, offset, limit));
        }
    };
    private final Cache<Class<?>, Boolean> objectVerificationCache = CacheBuilder.newBuilder().maximumSize(10000L).concurrencyLevel(4).initialCapacity(32).build();

    public KryoSerializer(List<Class> defaultRegistrations) {
        this(defaultRegistrations, false);
    }

    public KryoSerializer(final List<Class> defaultRegistrations, boolean registrationRequired) {
        this.registerRequired = registrationRequired;
        this.registrations = new HashMap<Integer, TypeRegistration>();
        for (Class clazz : defaultRegistrations) {
            this.objectVerificationCache.put((Object)clazz, (Object)Boolean.TRUE);
        }
        this.kryos = new ThreadLocal<Kryo>(){

            @Override
            public Kryo initialValue() {
                Kryo k = new Kryo();
                k.setRegistrationRequired(KryoSerializer.this.registerRequired);
                k.register(Class.class, (Serializer)new DefaultSerializers.ClassSerializer());
                for (int i = 0; i < defaultRegistrations.size(); ++i) {
                    Class clazz = (Class)defaultRegistrations.get(i);
                    k.register(clazz, 50 + i);
                }
                return k;
            }
        };
    }

    Kryo getKryo() {
        return this.kryos.get();
    }

    public Object readClassAndObject(ReadBuffer buffer) {
        Input i = buffer.asRelative(INPUT_FACTORY);
        int startPos = i.position();
        Object value = this.getKryo().readClassAndObject(i);
        buffer.movePositionTo(buffer.getPosition() + i.position() - startPos);
        return value;
    }

    public <T> T readObjectNotNull(ReadBuffer buffer, Class<T> type) {
        Input i = buffer.asRelative(INPUT_FACTORY);
        int startPos = i.position();
        Object value = this.getKryo().readObject(i, type);
        buffer.movePositionTo(buffer.getPosition() + i.position() - startPos);
        return (T)value;
    }

    private Output getOutput(Object object) {
        return new Output(128, 0xA00000);
    }

    private void writeOutput(WriteBuffer out, Output output) {
        byte[] array = output.getBuffer();
        int limit = output.position();
        for (int i = 0; i < limit; ++i) {
            out.putByte(array[i]);
        }
    }

    public void writeObjectNotNull(WriteBuffer out, Object object) {
        Preconditions.checkNotNull((Object)object);
        Preconditions.checkArgument((boolean)this.isValidObject(object), (String)"Cannot de-/serialize object: %s", (Object[])new Object[]{object});
        Output output = this.getOutput(object);
        this.getKryo().writeObject(output, object);
        this.writeOutput(out, output);
    }

    public void writeClassAndObject(WriteBuffer out, Object object) {
        Preconditions.checkArgument((boolean)this.isValidObject(object), (String)"Cannot de-/serialize object: %s", (Object[])new Object[]{object});
        Output output = this.getOutput(object);
        this.getKryo().writeClassAndObject(output, object);
        this.writeOutput(out, output);
    }

    final boolean isValidObject(Object o) {
        if (o == null) {
            return true;
        }
        Boolean status = (Boolean)this.objectVerificationCache.getIfPresent(o.getClass());
        if (status == null) {
            Kryo kryo = this.getKryo();
            if (!(kryo.getSerializer(o.getClass()) instanceof FieldSerializer)) {
                status = Boolean.TRUE;
            } else if (!KryoSerializer.isValidClass(o.getClass())) {
                status = Boolean.FALSE;
            } else {
                try {
                    Output out = new Output(128, 0xA00000);
                    kryo.writeClassAndObject(out, o);
                    Input in = new Input(out.getBuffer(), 0, out.position());
                    Object ocopy = kryo.readClassAndObject(in);
                    status = o.equals(ocopy) ? Boolean.TRUE : Boolean.FALSE;
                }
                catch (Throwable e) {
                    status = Boolean.FALSE;
                }
            }
            this.objectVerificationCache.put(o.getClass(), (Object)status);
        }
        return status;
    }

    public static final boolean isValidClass(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return true;
        }
        if (type.isArray()) {
            return KryoSerializer.isValidClass(type.getComponentType());
        }
        for (Constructor<?> c : type.getDeclaredConstructors()) {
            if (c.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    private static class TypeRegistration {
        final Class type;
        final Serializer serializer;

        TypeRegistration(Class type, Serializer serializer) {
            this.type = type;
            this.serializer = serializer;
        }
    }
}

