/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.util;

import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.jboss.aesh.console.Config;

public class LoggerUtil {
    private static Handler logHandler;

    private static void createLogHandler(String log) {
        try {
            File logFile = new File(log);
            if (logFile.getParentFile() != null && !logFile.getParentFile().isDirectory()) {
                if (!logFile.getParentFile().mkdirs()) {
                    logHandler = new ConsoleHandler();
                    logHandler.setFormatter(new SimpleFormatter());
                    return;
                }
            } else if (logFile.isDirectory()) {
                logFile = new File(logFile.getAbsolutePath() + Config.getPathSeparator() + "aesh.log");
            }
            logHandler = new FileHandler(logFile.getAbsolutePath());
            logHandler.setFormatter(new SimpleFormatter());
        }
        catch (IOException e) {
            logHandler = new ConsoleHandler();
            logHandler.setFormatter(new SimpleFormatter());
        }
    }

    public static synchronized Logger getLogger(String name) {
        if (logHandler == null) {
            LoggerUtil.createLogHandler(Config.getTmpDir() + Config.getPathSeparator() + "aesh.log");
        }
        if (logHandler == null) {
            return Logger.getLogger(name);
        }
        Logger log = Logger.getLogger(name);
        log.setUseParentHandlers(false);
        log.addHandler(logHandler);
        return log;
    }
}

