/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.service;

import org.jboss.forge.roaster.model.util.Types;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.exception.NonUniqueResultException;
import org.jboss.windup.rules.apps.java.model.AmbiguousJavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaMethodModel;
import org.jboss.windup.rules.apps.java.model.JavaParameterModel;

public class JavaClassService
extends GraphService<JavaClassModel> {
    public JavaClassService(GraphContext context) {
        super(context, JavaClassModel.class);
    }

    public JavaClassModel getUniqueByName(String qualifiedName) throws NonUniqueResultException {
        return (JavaClassModel)this.getUniqueByProperty("qualifiedName", qualifiedName);
    }

    public synchronized JavaClassModel getOrCreate(String qualifiedName) throws NonUniqueResultException {
        JavaClassModel clz = this.resolveByQualifiedName(qualifiedName);
        if (clz == null) {
            clz = (JavaClassModel)this.create();
            clz.setQualifiedName(qualifiedName);
            clz.setSimpleName(Types.toSimpleName((String)qualifiedName));
            clz.setPackageName(Types.getPackage((String)qualifiedName));
        }
        return clz;
    }

    public Iterable<JavaClassModel> findByJavaClassPattern(String regex) {
        return super.findAllByPropertyMatchingRegex("qualifiedName", new String[]{regex});
    }

    public Iterable<JavaClassModel> findByJavaPackage(String packageName) {
        return this.getGraphContext().getQuery().type(JavaClassModel.class).has("packageName", (Object)packageName).vertices(this.getType());
    }

    public Iterable<JavaClassModel> findByJavaVersion(JavaVersion version) {
        return this.getGraphContext().getQuery().type(JavaClassModel.class).has("majorVersion", (Object)version.getMajor()).has("minorVersion", (Object)version.getMinor()).vertices(this.getType());
    }

    public JavaClassModel resolveByQualifiedName(String qualifiedClassName) {
        try {
            JavaClassModel model = (JavaClassModel)this.getUniqueByProperty("qualifiedName", qualifiedClassName);
            return model;
        }
        catch (NonUniqueResultException e) {
            Iterable candidates = this.findAllByProperty("qualifiedName", qualifiedClassName);
            for (JavaClassModel candidate : candidates) {
                if (!(candidate instanceof AmbiguousJavaClassModel)) continue;
                return candidate;
            }
            GraphService ambiguousJavaClassModelService = new GraphService(this.getGraphContext(), AmbiguousJavaClassModel.class);
            AmbiguousJavaClassModel ambiguousModel = (AmbiguousJavaClassModel)ambiguousJavaClassModelService.create();
            for (JavaClassModel candidate : candidates) {
                ambiguousModel.setSimpleName(Types.toSimpleName((String)qualifiedClassName));
                ambiguousModel.setPackageName(Types.getPackage((String)qualifiedClassName));
                ambiguousModel.setQualifiedName(qualifiedClassName);
                ambiguousModel.addReference(candidate);
            }
            return ambiguousModel;
        }
    }

    public JavaMethodModel addJavaMethod(JavaClassModel jcm, String methodName, JavaClassModel[] params) {
        JavaMethodModel javaMethodModel = (JavaMethodModel)this.getGraphContext().getFramed().addVertex(null, JavaMethodModel.class);
        javaMethodModel.setMethodName(methodName);
        for (int i = 0; i < params.length; ++i) {
            JavaClassModel param = params[i];
            JavaParameterModel paramModel = (JavaParameterModel)this.getGraphContext().getFramed().addVertex(null, JavaParameterModel.class);
            paramModel.setJavaType(param);
            paramModel.setPosition(i);
            javaMethodModel.addMethodParameter(paramModel);
        }
        jcm.addJavaMethod(javaMethodModel);
        return javaMethodModel;
    }

    public static enum JavaVersion {
        JAVA_8(8, 0),
        JAVA_7(7, 0),
        JAVA_6(6, 0),
        JAVA_5(5, 0),
        JAVA_1_4(1, 4),
        JAVA_1_3(1, 3),
        JAVA_1_2(1, 2),
        JAVA_1_1(1, 1);

        final int major;
        final int minor;

        private JavaVersion(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }
    }
}

