/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.raw;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.StoreExistsException;
import com.sleepycat.persist.StoreNotFoundException;
import com.sleepycat.persist.evolve.IncompatibleClassException;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.impl.Store;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.raw.RawObject;
import java.io.Closeable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawStore
implements Closeable {
    private Store store;

    public RawStore(Environment env, String storeName, StoreConfig config) throws StoreNotFoundException, DatabaseException {
        try {
            this.store = new Store(env, storeName, config, true);
        }
        catch (StoreExistsException e) {
            throw DbCompat.unexpectedException(e);
        }
        catch (IncompatibleClassException e) {
            throw DbCompat.unexpectedException(e);
        }
    }

    public PrimaryIndex<Object, RawObject> getPrimaryIndex(String entityClass) throws DatabaseException {
        return this.store.getPrimaryIndex(Object.class, null, RawObject.class, entityClass);
    }

    public SecondaryIndex<Object, Object, RawObject> getSecondaryIndex(String entityClass, String keyName) throws DatabaseException {
        return this.store.getSecondaryIndex(this.getPrimaryIndex(entityClass), RawObject.class, entityClass, Object.class, null, keyName);
    }

    public Environment getEnvironment() {
        return this.store.getEnvironment();
    }

    public StoreConfig getConfig() {
        return this.store.getConfig();
    }

    public String getStoreName() {
        return this.store.getStoreName();
    }

    public EntityModel getModel() {
        return this.store.getModel();
    }

    public Mutations getMutations() {
        return this.store.getMutations();
    }

    @Override
    public void close() throws DatabaseException {
        this.store.close();
    }
}

