/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules.generation;

import javax.inject.Inject;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.RulePhase;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderPiped;
import org.jboss.windup.config.query.QueryGremlinCriterion;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.SourceTypeResolver;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.FreeMarkerSourceReportModel;
import org.jboss.windup.reporting.model.ReportFileModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.source.SourceReportModel;
import org.jboss.windup.reporting.query.FindClassifiedFilesGremlinCriterion;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.reporting.service.SourceReportModelService;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CreateSourceReportRuleProvider
extends WindupRuleProvider {
    private static final String TEMPLATE = "/reports/templates/source.ftl";
    @Inject
    private Imported<SourceTypeResolver> resolvers;

    public RulePhase getPhase() {
        return RulePhase.POST_REPORT_GENERATION;
    }

    public Configuration getConfiguration(GraphContext context) {
        QueryBuilderPiped finder = Query.find(SourceFileModel.class).piped((QueryGremlinCriterion)new FindClassifiedFilesGremlinCriterion());
        AbstractIterationOperation<FileModel> addSourceReport = new AbstractIterationOperation<FileModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, FileModel payload) {
                SourceReportModelService sourceReportModelService = new SourceReportModelService(event.getGraphContext());
                SourceReportModel sm = (SourceReportModel)sourceReportModelService.create();
                ReportFileModel reportFileModel = (ReportFileModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)payload, ReportFileModel.class);
                sm.setSourceFileModel(reportFileModel);
                sm.setReportName(payload.getPrettyPath());
                sm.setSourceType(CreateSourceReportRuleProvider.this.resolveSourceType(payload));
                sm.setReportName(payload.getFileName());
                sm.setTemplatePath(CreateSourceReportRuleProvider.TEMPLATE);
                sm.setTemplateType(TemplateType.FREEMARKER);
                ApplicationReportService applicationReportService = new ApplicationReportService(event.getGraphContext());
                ApplicationReportModel mainAppReport = applicationReportService.getMainApplicationReportForFile(payload);
                if (mainAppReport != null) {
                    sm.setParentReport((ReportModel)mainAppReport);
                }
                GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)sm, FreeMarkerSourceReportModel.class);
                ReportService reportService = new ReportService(event.getGraphContext());
                reportService.setUniqueFilename((ReportModel)sm, payload.getFileName(), "html");
            }

            public String toString() {
                return "AddSourceReport";
            }
        };
        return ConfigurationBuilder.begin().addRule().when((Condition)finder).perform((Operation)addSourceReport);
    }

    private String resolveSourceType(FileModel f) {
        for (SourceTypeResolver resolver : this.resolvers) {
            String resolvedType = resolver.resolveSourceType(f);
            if (resolvedType == null) continue;
            return resolvedType;
        }
        return "unknown";
    }
}

