/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.Type;
import org.apache.commons.lang.StringUtils;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.util.ExecutionStatistics;
import org.ocpsoft.rewrite.config.OperationBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class AddClassFileMetadata
extends AbstractIterationOperation<FileModel> {
    private static Logger LOG = Logger.getLogger(AddClassFileMetadata.class.getSimpleName());

    private AddClassFileMetadata(String variableName) {
        super(variableName);
    }

    public AddClassFileMetadata() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void perform(GraphRewrite event, EvaluationContext context, FileModel payload) {
        ExecutionStatistics.get().begin("AddClassFileMetadata.perform()");
        try (FileInputStream fis = new FileInputStream(payload.getFilePath());){
            void var20_29;
            Constant[] pool;
            ClassParser parser = new ClassParser((InputStream)fis, payload.getFilePath());
            final JavaClass bcelJavaClass = parser.parse();
            String packageName = bcelJavaClass.getPackageName();
            String qualifiedName = bcelJavaClass.getClassName();
            int majorVersion = bcelJavaClass.getMajor();
            int minorVersion = bcelJavaClass.getMinor();
            String simpleName = qualifiedName;
            if (packageName != null && !packageName.equals("") && simpleName != null) {
                simpleName = simpleName.substring(packageName.length() + 1);
            }
            JavaClassFileModel classFileModel = (JavaClassFileModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)payload, JavaClassFileModel.class);
            classFileModel.setMajorVersion(majorVersion);
            classFileModel.setMinorVersion(minorVersion);
            classFileModel.setPackageName(packageName);
            final JavaClassService javaClassService = new JavaClassService(event.getGraphContext());
            final JavaClassModel javaClassModel = javaClassService.getOrCreate(qualifiedName);
            javaClassModel.setSimpleName(simpleName);
            javaClassModel.setPackageName(packageName);
            javaClassModel.setQualifiedName(qualifiedName);
            javaClassModel.setClassFile(classFileModel);
            String[] interfaceNames = bcelJavaClass.getInterfaceNames();
            if (interfaceNames != null) {
                for (String string : interfaceNames) {
                    JavaClassModel interfaceModel = javaClassService.getOrCreate(string);
                    javaClassModel.addImplements(interfaceModel);
                }
            }
            for (String string : bcelJavaClass.getMethods()) {
                javaClassService.addJavaMethod(javaClassModel, string.getName(), this.toJavaClasses(javaClassService, string.getArgumentTypes()));
            }
            Constant[] arr$ = pool = bcelJavaClass.getConstantPool().getConstantPool();
            int len$ = arr$.length;
            boolean bl = false;
            while (var20_29 < len$) {
                Constant c = arr$[var20_29];
                if (c != null) {
                    c.accept((Visitor)new EmptyVisitor(){

                        public void visitConstantClass(ConstantClass obj) {
                            ConstantPool pool = bcelJavaClass.getConstantPool();
                            String classVal = obj.getConstantValue(pool).toString();
                            if (StringUtils.equals((String)(classVal = StringUtils.replace((String)classVal, (String)"/", (String)".")), (String)bcelJavaClass.getClassName())) {
                                return;
                            }
                            JavaClassModel clz = javaClassService.getOrCreate(classVal);
                            javaClassModel.addImport(clz);
                        }
                    });
                }
                ++var20_29;
            }
            String superclassName = bcelJavaClass.getSuperclassName();
            if (Strings.isNullOrEmpty((String)superclassName)) {
                javaClassModel.setExtends(javaClassService.getOrCreate(superclassName));
            }
            classFileModel.setJavaClass(javaClassModel);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "BCEL was unable to parse class file: " + payload.getFilePath() + " due to: " + e.getMessage(), e);
            ClassificationService classificationService = new ClassificationService(event.getGraphContext());
            classificationService.attachClassification(payload, "Unparseable Class File", "This Class file could not be parsed");
        }
        finally {
            ExecutionStatistics.get().end("AddClassFileMetadata.perform()");
        }
    }

    private JavaClassModel[] toJavaClasses(JavaClassService javaClassService, Type[] types) {
        JavaClassModel[] clz = new JavaClassModel[types.length];
        for (Type t : types) {
            clz[i] = javaClassService.getOrCreate(t.toString());
        }
        return clz;
    }

    public static OperationBuilder to(String var) {
        return new AddClassFileMetadata(var);
    }
}

