/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.controller;

import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.addon.ui.UIRuntime;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.command.UICommandTransformer;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.controller.CommandControllerFactory;
import org.jboss.forge.addon.ui.controller.SingleCommandController;
import org.jboss.forge.addon.ui.controller.WizardCommandController;
import org.jboss.forge.addon.ui.impl.controller.NoUIWizardControllerDecorator;
import org.jboss.forge.addon.ui.impl.controller.SingleCommandControllerImpl;
import org.jboss.forge.addon.ui.impl.controller.WizardCommandControllerImpl;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.services.Imported;

@Singleton
public class CommandControllerFactoryImpl
implements CommandControllerFactory {
    private final AddonRegistry addonRegistry;
    private final Imported<UICommandTransformer> transformers;
    private final Logger log = Logger.getLogger(this.getClass().getName());

    @Inject
    public CommandControllerFactoryImpl(AddonRegistry addonRegistry) {
        this.addonRegistry = addonRegistry;
        this.transformers = this.addonRegistry.getServices(UICommandTransformer.class);
    }

    public CommandController createController(UIContext context, UIRuntime runtime, UICommand originalCommand) {
        UICommand command = this.transform(context, originalCommand);
        if (command instanceof UIWizard) {
            return this.doCreateWizardController(context, runtime, (UIWizard)command);
        }
        return this.doCreateSingleController(context, runtime, command);
    }

    public SingleCommandController createSingleController(UIContext context, UIRuntime runtime, UICommand originalCommand) {
        UICommand command = this.transform(context, originalCommand);
        return this.doCreateSingleController(context, runtime, command);
    }

    public WizardCommandController createWizardController(UIContext context, UIRuntime runtime, UIWizard wizard) {
        UICommand command = this.transform(context, (UICommand)wizard);
        if (command instanceof UIWizard) {
            return this.doCreateWizardController(context, runtime, (UIWizard)command);
        }
        throw new IllegalStateException("Impossible to create a WizardController from enriched command " + command);
    }

    private UICommand transform(UIContext context, UICommand originalCommand) {
        UICommand command = originalCommand;
        for (UICommandTransformer transformer : this.transformers) {
            UICommand tmpCommand = transformer.transform(context, command);
            if (tmpCommand == null) {
                this.log.warning(UICommandTransformer.class.getName() + " implementation " + Proxies.unwrapProxyClassName(transformer.getClass()) + " should not have returned null. Ignoring.");
                continue;
            }
            command = tmpCommand;
        }
        return command;
    }

    WizardCommandController doCreateWizardController(UIContext context, UIRuntime runtime, UIWizard wizard) {
        WizardCommandControllerImpl controller = new WizardCommandControllerImpl(context, this.addonRegistry, runtime, wizard, this);
        return new NoUIWizardControllerDecorator(controller);
    }

    SingleCommandController doCreateSingleController(UIContext context, UIRuntime runtime, UICommand command) {
        return new SingleCommandControllerImpl(this.addonRegistry, runtime, command, context);
    }
}

