/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.connector.outbound;

import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import org.xadisk.connector.outbound.XADiskManagedConnection;
import org.xadisk.filesystem.XAFileSystemCommonness;
import org.xadisk.filesystem.exceptions.NoTransactionAssociatedException;

public class XADiskLocalTransaction
implements LocalTransaction {
    private final XADiskManagedConnection mc;
    private int transactionTimeOut;

    public XADiskLocalTransaction(XADiskManagedConnection mc) {
        this.mc = mc;
        XAFileSystemCommonness xaFileSystem = (XAFileSystemCommonness)mc.getUnderlyingXAFileSystem();
        this.transactionTimeOut = xaFileSystem.getDefaultTransactionTimeout();
    }

    void _begin() {
        this.mc.setTypeOfCurrentTransaction((byte)1);
        this.mc.refreshSessionForBeginLocalTransaction().setTransactionTimeout(this.transactionTimeOut);
    }

    public void begin() throws ResourceException {
        this._begin();
    }

    void _rollback() throws NoTransactionAssociatedException {
        this.mc.setTypeOfCurrentTransaction((byte)0);
        this.mc.getSessionOfLocalTransaction().rollback();
    }

    public void rollback() throws ResourceException {
        try {
            this._rollback();
        }
        catch (NoTransactionAssociatedException note) {
            throw new ResourceException((Throwable)note);
        }
    }

    void _commit() throws NoTransactionAssociatedException {
        this.mc.setTypeOfCurrentTransaction((byte)0);
        this.mc.getSessionOfLocalTransaction().commit();
    }

    public void commit() throws ResourceException {
        try {
            this._commit();
        }
        catch (NoTransactionAssociatedException note) {
            throw new ResourceException((Throwable)note);
        }
    }

    int getTransactionTimeOut() {
        return this.transactionTimeOut;
    }

    void setTransactionTimeOut(int transactionTimeOut) {
        this.transactionTimeOut = transactionTimeOut;
    }
}

