/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.util.ResourcePathResolver;
import org.jboss.forge.addon.shell.spi.command.CdTokenHandler;
import org.jboss.forge.addon.shell.spi.command.CdTokenHandlerFactory;
import org.jboss.forge.addon.shell.ui.AbstractShellCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

public class CdCommand
extends AbstractShellCommand {
    private static final Logger log = Logger.getLogger(CdCommand.class.getName());
    @Inject
    private ResourceFactory resourceFactory;
    @Inject
    private CdTokenHandlerFactory tokenHandlerFactory;
    @Inject
    @WithAttributes(label="Arguments", type="org.jboss.forge.inputType.FILE_PICKER")
    private UIInputMany<String> arguments;

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.arguments);
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("cd").description("Change the current directory");
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Result result;
        Iterator it;
        UIContext uiContext = context.getUIContext();
        Iterable value = this.arguments.getValue();
        Iterator iterator = it = value == null ? Collections.emptyIterator() : value.iterator();
        if (it.hasNext()) {
            String token = (String)it.next();
            List newResource = null;
            for (CdTokenHandler handler : this.tokenHandlerFactory.getHandlers()) {
                try {
                    newResource = handler.getNewCurrentResources(uiContext, token);
                    if (newResource == null || !newResource.isEmpty()) break;
                    newResource = null;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Error encountered during processing of [" + handler + "] for path token [" + token + "].", e);
                }
            }
            if (newResource == null) {
                Resource currentResource = (Resource)uiContext.getInitialSelection().get();
                newResource = new ResourcePathResolver(this.resourceFactory, currentResource, token).resolve();
            }
            if (newResource.isEmpty() || !((Resource)newResource.get(0)).exists()) {
                result = Results.fail((String)(token + ": No such file or directory"));
            } else {
                FileResource newFileResource = (FileResource)((Resource)newResource.get(0)).reify(FileResource.class);
                if (newFileResource == null) {
                    result = Results.fail((String)(token + ": Invalid path"));
                } else {
                    uiContext.setSelection((Object)newFileResource);
                    result = Results.success();
                }
            }
        } else {
            result = Results.success();
        }
        return result;
    }
}

