/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.confighandler;

import java.nio.file.Path;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.rules.apps.xml.operation.xslt.XSLTTransformation;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="xslt", namespace="http://windup.jboss.org/v1/xml")
public class XSLTTransformationHandler
implements ElementHandler<XSLTTransformation> {
    public XSLTTransformation processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String description = JOOX.$((Element)element).attr("description");
        String extension = JOOX.$((Element)element).attr("extension");
        String template = JOOX.$((Element)element).attr("template");
        if (StringUtils.isBlank((String)description)) {
            throw new WindupException("Error, 'xslt' element must have a non-empty 'description' attribute");
        }
        if (StringUtils.isBlank((String)template)) {
            throw new WindupException("Error, 'xslt' element must have a non-empty 'template' attribute");
        }
        if (StringUtils.isBlank((String)extension)) {
            throw new WindupException("Error, 'xslt' element must have a non-empty 'extension' attribute");
        }
        Path pathContainingXml = handlerManager.getXmlInputPath();
        if (pathContainingXml != null) {
            String fullPath = template.startsWith("/") || template.startsWith("\\") ? template : pathContainingXml.resolve(template).toAbsolutePath().toString();
            return XSLTTransformation.usingFilesystem(fullPath).withDescription(description).withExtension(extension);
        }
        ClassLoader xmlFileAddonClassLoader = handlerManager.getAddonContainingInputXML().getClassLoader();
        return XSLTTransformation.using(template, xmlFileAddonClassLoader).withDescription(description).withExtension(extension);
    }
}

