/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.sisu.inject.DeferredClass;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.URLClassSpace;
import org.eclipse.sisu.space.asm.ClassWriter;
import org.eclipse.sisu.space.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CloningClassSpace
extends URLClassSpace {
    private static final String CLONE_MARKER = "$__sisu";
    private int cloneCount;

    public CloningClassSpace(final ClassSpace parent) {
        super(AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new CloningClassLoader(parent);
            }
        }), null);
    }

    public DeferredClass<?> cloneClass(String name) {
        StringBuilder buf = new StringBuilder();
        if (name.startsWith("java")) {
            buf.append('$');
        }
        return this.deferLoadClass(buf.append(name).append(CLONE_MARKER).append(++this.cloneCount).toString());
    }

    public static String originalName(String proxyName) {
        int cloneMarker = proxyName.lastIndexOf(CLONE_MARKER);
        if (cloneMarker < 0) {
            return proxyName;
        }
        int i = cloneMarker + CLONE_MARKER.length();
        int end = proxyName.length();
        while (i < end) {
            char c = proxyName.charAt(i);
            if (c < '0' || c > '9') {
                return proxyName;
            }
            ++i;
        }
        return proxyName.substring('$' == proxyName.charAt(0) ? 1 : 0, cloneMarker);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CloningClassLoader
    extends ClassLoader {
        private final ClassSpace parent;

        CloningClassLoader(ClassSpace parent) {
            this.parent = parent;
        }

        public String toString() {
            return this.parent.toString();
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (!name.contains(CloningClassSpace.CLONE_MARKER)) {
                try {
                    return this.parent.loadClass(name);
                }
                catch (TypeNotPresentException typeNotPresentException) {
                    throw new ClassNotFoundException(name);
                }
            }
            return super.loadClass(name, resolve);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            String proxyName = name.replace('.', '/');
            String superName = CloningClassSpace.originalName(proxyName);
            if (superName.equals(proxyName)) {
                throw new ClassNotFoundException(name);
            }
            ClassWriter cw = new ClassWriter(1);
            cw.visit(49, 1, proxyName, null, superName, null);
            MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, superName, "<init>", "()V");
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            cw.visitEnd();
            byte[] buf = cw.toByteArray();
            return this.defineClass(name, buf, 0, buf.length);
        }
    }
}

