/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.cdi.weld;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import org.jboss.forge.furnace.container.cdi.weld.ModularFileSystemURLHandler;
import org.jboss.forge.furnace.container.cdi.weld.ModuleScanResult;
import org.jboss.weld.environment.se.discovery.url.ClasspathScanningException;
import org.jboss.weld.resources.spi.ResourceLoader;

public class ModularURLScanner {
    private final String[] resources;
    private final ResourceLoader resourceLoader;

    public ModularURLScanner(ResourceLoader resourceLoader, String ... resources) {
        this.resources = resources;
        this.resourceLoader = resourceLoader;
    }

    public ModuleScanResult scan() {
        ArrayList<String> discoveredClasses = new ArrayList<String>();
        ArrayList<URL> discoveredResourceUrls = new ArrayList<URL>();
        ArrayList<String> paths = new ArrayList<String>();
        for (String resourceName : this.resources) {
            Collection urlEnum = this.resourceLoader.getResources(resourceName);
            for (URL url : urlEnum) {
                String urlPath = url.toExternalForm();
                String urlType = "file";
                int colonIndex = urlPath.indexOf(":");
                if (colonIndex != -1) {
                    urlType = urlPath.substring(0, colonIndex);
                }
                if ("file".equals(urlType) || "jar".equals(urlType)) {
                    urlPath = url.getPath();
                    if (urlPath.indexOf(33) > 0) {
                        urlPath = urlPath.substring(0, urlPath.indexOf(33));
                    } else {
                        File dirOrArchive = new File(urlPath);
                        if (resourceName != null && resourceName.lastIndexOf(47) > 0) {
                            dirOrArchive = dirOrArchive.getParentFile();
                        }
                        urlPath = dirOrArchive.getParent();
                    }
                }
                try {
                    urlPath = URLDecoder.decode(urlPath, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new ClasspathScanningException("Error decoding URL using UTF-8");
                }
                paths.add(urlPath);
            }
            ModularFileSystemURLHandler handler = new ModularFileSystemURLHandler(this.resourceLoader);
            handler.handle(paths, discoveredClasses, discoveredResourceUrls);
        }
        return new ModuleScanResult(this.resourceLoader, discoveredResourceUrls, discoveredClasses);
    }
}

