/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import org.jboss.aesh.io.filter.ResourceFilter;

public interface Resource {
    public String getName();

    public String getAbsolutePath();

    public boolean isLeaf();

    public boolean isDirectory();

    public boolean isSymbolicLink();

    public Resource readSymbolicLink() throws IOException;

    public boolean exists();

    public boolean mkdirs();

    public boolean delete();

    public Resource getParent();

    public List<Resource> list();

    public List<Resource> list(ResourceFilter var1);

    public List<Resource> listRoots();

    public List<Resource> resolve(Resource var1);

    public OutputStream write(boolean var1) throws FileNotFoundException;

    public InputStream read() throws FileNotFoundException;

    public <A extends BasicFileAttributes> A readAttributes(Class<A> var1, LinkOption ... var2) throws IOException;

    public Resource newInstance(String var1);

    public Resource copy(Resource var1) throws IOException;

    public boolean setLastModified(long var1);

    public long lastModified();
}

