/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import java.util.logging.Logger;
import org.jboss.aesh.terminal.InfocmpHandler;
import org.jboss.aesh.util.LoggerUtil;

public class InfocmpManager {
    private static final Logger LOGGER = LoggerUtil.getLogger(InfocmpManager.class.getName());

    public static int[] getKeyHome() {
        int[] home = InfocmpHandler.getInstance().getAsInts("khome");
        if (home.length == 0) {
            LOGGER.warning("Failed to get key home from infocmp, using default");
            return new int[]{27, 79, 72};
        }
        return home;
    }

    public static int[] getCursorHome() {
        int[] home = InfocmpHandler.getInstance().getAsInts("home");
        if (home.length == 0) {
            LOGGER.warning("Failed to get cursor home from infocmp, using default");
            return new int[]{27, 91, 72};
        }
        return home;
    }

    public static int[] getEnd() {
        int[] infocmpValue = InfocmpHandler.getInstance().getAsInts("end");
        if (infocmpValue.length == 0) {
            LOGGER.warning("Failed to get end from infocmp, using default");
            return new int[]{27, 79, 70};
        }
        return infocmpValue;
    }

    public static int[] getPgUp() {
        int[] infocmpValue = InfocmpHandler.getInstance().getAsInts("kpp");
        if (infocmpValue.length == 0) {
            LOGGER.warning("Failed to get pgup from infocmp, using default");
            return new int[]{27, 91, 53, 126};
        }
        return infocmpValue;
    }

    public static int[] getPgDown() {
        int[] infocmpValue = InfocmpHandler.getInstance().getAsInts("knp");
        if (infocmpValue.length == 0) {
            LOGGER.warning("Failed to get pgdown from infocmp, using default");
            return new int[]{27, 91, 54, 126};
        }
        return infocmpValue;
    }

    public static int[] getLeft() {
        int[] infocmpValue = InfocmpHandler.getInstance().getAsInts("kcub1");
        if (infocmpValue.length == 0) {
            LOGGER.warning("Failed to get left from infocmp, using default");
            return new int[]{27, 79, 68};
        }
        return infocmpValue;
    }

    public static int[] getRight() {
        int[] infocmpValue = InfocmpHandler.getInstance().getAsInts("cuf1");
        if (infocmpValue.length == 0) {
            LOGGER.warning("Failed to get right from infocmp, using default");
            return new int[]{27, 79, 68};
        }
        return infocmpValue;
    }

    public static int[] getUp() {
        int[] infocmpValue = InfocmpHandler.getInstance().getAsInts("kcuu1");
        if (infocmpValue.length == 0) {
            LOGGER.warning("Failed to get up from infocmp, using default");
            return new int[]{27, 79, 65};
        }
        return infocmpValue;
    }

    public static int[] getDown() {
        int[] infocmpValue = InfocmpHandler.getInstance().getAsInts("kcud1");
        if (infocmpValue.length == 0) {
            LOGGER.warning("Failed to get down from infocmp, using default");
            return new int[]{27, 79, 66};
        }
        return infocmpValue;
    }

    public static int[] getIns() {
        int[] infocmpValue = InfocmpHandler.getInstance().getAsInts("kich1");
        if (infocmpValue.length == 0) {
            LOGGER.warning("Failed to get insert from infocmp, using default");
            return new int[]{27, 91, 50, 126};
        }
        return infocmpValue;
    }

    public static int[] getDelete() {
        int[] infocmpValue = InfocmpHandler.getInstance().getAsInts("kdch1");
        if (infocmpValue.length == 0) {
            LOGGER.warning("Failed to get delete from infocmp, using default");
            return new int[]{27, 91, 51, 126};
        }
        return infocmpValue;
    }

    public static String saveCursor() {
        String cursor = InfocmpHandler.getInstance().get("sc");
        if (cursor.length() == 0) {
            LOGGER.warning("Failed to get save_cursor from infocmp, using default");
            return "\u001b[s";
        }
        return cursor;
    }

    public static String restoreCursor() {
        String cursor = InfocmpHandler.getInstance().get("rc");
        if (cursor.length() == 0) {
            LOGGER.warning("Failed to get restore_cursor from infocmp, using default");
            return "\u001b[u";
        }
        return cursor;
    }

    public static String clearScreen() {
        String clear = InfocmpHandler.getInstance().get("clear");
        if (clear.length() == 0) {
            LOGGER.warning("Failed to get clear from infocmp, using default");
            return "\u001b[2J";
        }
        return clear;
    }

    public static String alternateBuffer() {
        String buffer = InfocmpHandler.getInstance().get("smcup");
        if (buffer.length() == 0) {
            LOGGER.warning("Failed to get alternate buffer from infocmp, using default");
            return "\u001b[?1049h";
        }
        return buffer;
    }

    public static String mainBuffer() {
        String buffer = InfocmpHandler.getInstance().get("rmcup");
        if (buffer.length() == 0) {
            LOGGER.warning("Failed to get main buffer from infocmp, using default");
            return "\u001b[?1049l";
        }
        return buffer;
    }

    public static String invertBackground() {
        String buffer = InfocmpHandler.getInstance().get("smso");
        if (buffer.length() == 0) {
            LOGGER.warning("Failed to invert background from infocmp, using default");
            return "\u001b[7m";
        }
        return buffer;
    }

    public static String normalBackground() {
        String buffer = InfocmpHandler.getInstance().get("rmso");
        if (buffer.length() == 0) {
            LOGGER.warning("Failed to reset to normal background from infocmp, using default");
            return "\u001b[27m";
        }
        return buffer;
    }

    public static String enableBold() {
        String bold = InfocmpHandler.getInstance().get("bold");
        if (bold.length() == 0) {
            LOGGER.warning("Failed to get bold from infocmp, using default");
            return "\u001b[0;1m";
        }
        return bold;
    }

    public static String enableUnderline() {
        String underline = InfocmpHandler.getInstance().get("smul");
        if (underline.length() == 0) {
            LOGGER.warning("Failed to get underline from infocmp, using default");
            return "\u001b[0;4m";
        }
        return underline;
    }

    public static String disableUnderline() {
        String underline = InfocmpHandler.getInstance().get("rmul");
        if (underline.length() == 0) {
            LOGGER.warning("Failed to exit underline from infocmp, using default");
            return "\u001b[0;24m";
        }
        return underline;
    }

    public static String enableBlink() {
        String blink = InfocmpHandler.getInstance().get("blink");
        if (blink.length() == 0) {
            LOGGER.warning("Failed to enable blink from infocmp, using default");
            return "\u001b[0;5m";
        }
        return blink;
    }

    public static String originalColors() {
        String reset = InfocmpHandler.getInstance().get("op");
        if (reset.length() == 0) {
            LOGGER.warning("Failed to reset from infocmp, using default");
            return "\u001b[0;0m";
        }
        return reset;
    }
}

