/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.jboss.aesh.console.reader.AeshInputStream;
import org.jboss.aesh.console.reader.AeshStandardStream;
import org.jboss.aesh.console.reader.ConsoleInputSession;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.terminal.CursorPosition;
import org.jboss.aesh.terminal.Shell;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.terminal.TerminalSize;

public class TestTerminal
implements Terminal,
Shell {
    private PrintStream outWriter;
    private PrintStream errWriter;
    private TerminalSize size;
    private AeshInputStream input;
    private ConsoleInputSession inputSession;
    private PrintStream stdOut;
    private PrintStream stdErr;

    @Override
    public void init(Settings settings) {
        this.inputSession = new ConsoleInputSession(settings.getInputStream());
        this.input = this.inputSession.getExternalInputStream();
        this.outWriter = new PrintStream(settings.getStdOut(), true);
        this.errWriter = new PrintStream(settings.getStdErr(), true);
        this.stdOut = settings.getStdOut();
        this.stdErr = settings.getStdErr();
        this.size = new TerminalSize(24, 80);
    }

    @Override
    public int[] read(boolean readAhead) throws IOException {
        if (readAhead) {
            return this.input.readAll();
        }
        int input = this.input.read();
        int available = this.input.available();
        if (available > 1) {
            int[] in = new int[available];
            in[0] = input;
            for (int c = 1; c < available; ++c) {
                in[c] = this.input.read();
            }
            return in;
        }
        return new int[]{input};
    }

    @Override
    public TerminalSize getSize() {
        return this.size;
    }

    @Override
    public CursorPosition getCursor() {
        return new CursorPosition(0, 0);
    }

    @Override
    public void setCursor(CursorPosition cp) {
    }

    @Override
    public void moveCursor(int r, int c) {
    }

    @Override
    public boolean isMainBuffer() {
        return true;
    }

    @Override
    public void enableAlternateBuffer() {
    }

    @Override
    public void enableMainBuffer() {
    }

    @Override
    public boolean isEchoEnabled() {
        return false;
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public void close() throws IOException {
        try {
            this.inputSession.stop();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Shell getShell() {
        return this;
    }

    @Override
    public AeshInputStream getInputStream() {
        return this.input;
    }

    @Override
    public void clear() throws IOException {
    }

    @Override
    public PrintStream err() {
        return this.errWriter;
    }

    @Override
    public AeshStandardStream in() {
        return new AeshStandardStream(new BufferedInputStream(this.input));
    }

    @Override
    public PrintStream out() {
        return this.outWriter;
    }
}

