/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.extensions.touch;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.io.Resource;

@CommandDefinition(name="touch", description="create and change file timestamps")
public class Touch
implements Command<CommandInvocation> {
    @Option(shortName=104, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Arguments
    private List<Resource> arguments;

    public CommandResult execute(CommandInvocation commandInvocation) throws IOException {
        if (this.help) {
            commandInvocation.getShell().out().print(commandInvocation.getHelpInfo("touch"));
            return CommandResult.SUCCESS;
        }
        if (this.arguments == null || this.arguments.size() < 1) {
            commandInvocation.getShell().out().print("touch: Invalid arguments");
            return CommandResult.FAILURE;
        }
        try {
            Resource currentWorkingDirectory = commandInvocation.getAeshContext().getCurrentWorkingDirectory();
            for (Resource file : this.arguments) {
                if (file.exists()) {
                    file.setLastModified(System.currentTimeMillis());
                }
                OutputStream out = ((Resource)file.resolve(currentWorkingDirectory).get(0)).write(false);
                Throwable throwable = null;
                try {
                    out.write("".getBytes());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    out.close();
                }
            }
        }
        catch (IOException ioe) {
            commandInvocation.getShell().out().print("touch: " + ioe.getMessage());
            return CommandResult.FAILURE;
        }
        return CommandResult.SUCCESS;
    }
}

