/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster;

import com.codahale.metrics.annotation.Timed;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.util.wrappers.WrapperGraph;
import com.tinkerpop.blueprints.util.wrappers.readonly.ReadOnlyGraph;
import com.tinkerpop.rexster.AbstractSubResource;
import com.tinkerpop.rexster.RexsterApplicationGraph;
import com.tinkerpop.rexster.extension.ExtensionMethod;
import com.tinkerpop.rexster.extension.ExtensionPoint;
import com.tinkerpop.rexster.extension.ExtensionResponse;
import com.tinkerpop.rexster.extension.ExtensionSegmentSet;
import com.tinkerpop.rexster.extension.HttpMethod;
import com.tinkerpop.rexster.extension.RexsterExtension;
import com.tinkerpop.rexster.server.RexsterApplication;
import java.util.List;
import java.util.ServiceConfigurationError;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@Path(value="/graphs/{graphname}")
public class GraphResource
extends AbstractSubResource {
    private static final Logger logger = Logger.getLogger(GraphResource.class);

    public GraphResource() {
        super(null);
    }

    public GraphResource(UriInfo ui, HttpServletRequest req, RexsterApplication ra) {
        super(ra);
        this.httpServletRequest = req;
        this.uriInfo = ui;
    }

    @OPTIONS
    public Response optionsGraph() {
        return this.buildOptionsResponse(HttpMethod.GET.toString(), HttpMethod.DELETE.toString());
    }

    @GET
    @Produces(value={"application/json"})
    @Timed(name="http.rest.graphs.object.get", absolute=true)
    public Response getGraphProducesJson(@PathParam(value="graphname") String graphName) {
        return this.getGraph(graphName, false);
    }

    @GET
    @Produces(value={"application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.graphs.object.get", absolute=true)
    public Response getGraphProducesRexsterJson(@PathParam(value="graphname") String graphName) {
        return this.getGraph(graphName, true);
    }

    private Response getGraph(String graphName, boolean showHypermedia) {
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        Graph graph = rag.getGraph();
        try {
            JSONArray extensionsList;
            this.resultObject.put("name", (Object)graphName);
            this.resultObject.put("graph", (Object)graph.toString());
            boolean isReadOnly = false;
            String graphType = graph.getClass().getName();
            if (graph instanceof WrapperGraph) {
                graphType = ((WrapperGraph)graph).getBaseGraph().getClass().getName();
                if (graph instanceof ReadOnlyGraph) {
                    isReadOnly = true;
                }
            }
            Features features = graph.getFeatures();
            this.resultObject.put("features", (Object)new JSONObject(features.toMap()));
            this.resultObject.put("readOnly", isReadOnly);
            this.resultObject.put("type", (Object)graphType);
            this.resultObject.put("queryTime", this.sh.stopWatch());
            this.resultObject.put("upTime", (Object)this.getTimeAlive());
            this.resultObject.put("version", (Object)"2.5.0");
            if (showHypermedia && (extensionsList = rag.getExtensionHypermedia(ExtensionPoint.GRAPH, this.getUriPath())) != null) {
                this.resultObject.put("extensions", (Object)extensionsList);
            }
        }
        catch (JSONException ex) {
            logger.error((Object)ex);
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        return Response.ok((Object)this.resultObject).build();
    }

    @HEAD
    @Path(value="{extension: (?!vertices)(?!edges)(?!indices)(?!keyindices)(?!prefixes).+}")
    @Consumes(value={"application/json"})
    public Response headGraphExtension(@PathParam(value="graphname") String graphName, JSONObject json) {
        this.setRequestObject(json);
        return this.executeGraphExtension(graphName, HttpMethod.HEAD);
    }

    @HEAD
    @Path(value="{extension: (?!vertices)(?!edges)(?!indices)(?!keyindices)(?!prefixes).+}")
    public Response headGraphExtension(@PathParam(value="graphname") String graphName) {
        return this.executeGraphExtension(graphName, HttpMethod.HEAD);
    }

    @PUT
    @Path(value="{extension: (?!vertices)(?!edges)(?!indices)(?!keyindices)(?!prefixes).+}")
    @Consumes(value={"application/json"})
    @Timed(name="http.rest.graphs.extension.put", absolute=true)
    public Response putGraphExtension(@PathParam(value="graphname") String graphName, JSONObject json) {
        this.setRequestObject(json);
        return this.executeGraphExtension(graphName, HttpMethod.PUT);
    }

    @PUT
    @Path(value="{extension: (?!vertices)(?!edges)(?!indices)(?!keyindices)(?!prefixes).+}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Timed(name="http.rest.graphs.extension.put", absolute=true)
    public Response putGraphExtension(@PathParam(value="graphname") String graphName, MultivaluedMap<String, String> formParams) {
        this.setRequestObject(formParams);
        return this.executeGraphExtension(graphName, HttpMethod.PUT);
    }

    @PUT
    @Path(value="{extension: (?!vertices)(?!edges)(?!indices)(?!keyindices)(?!prefixes).+}")
    @Timed(name="http.rest.graphs.extension.put", absolute=true)
    public Response putGraphExtension(@PathParam(value="graphname") String graphName) {
        return this.executeGraphExtension(graphName, HttpMethod.PUT);
    }

    @OPTIONS
    @Path(value="{extension: (?!vertices)(?!edges)(?!indices)(?!keyindices)(?!prefixes).+}")
    @Consumes(value={"application/json"})
    public Response optionsGraphExtension(@PathParam(value="graphname") String graphName, JSONObject json) {
        this.setRequestObject(json);
        return this.executeGraphExtension(graphName, HttpMethod.OPTIONS);
    }

    @OPTIONS
    @Path(value="{extension: (?!vertices)(?!edges)(?!indices)(?!keyindices)(?!prefixes).+}")
    public Response optionsGraphExtension(@PathParam(value="graphname") String graphName) {
        return this.executeGraphExtension(graphName, HttpMethod.OPTIONS);
    }

    @DELETE
    @Path(value="{extension: (?!vertices)(?!edges)(?!indices)(?!keyindices)(?!prefixes).+}")
    @Consumes(value={"application/json"})
    @Timed(name="http.rest.graphs.extension.delete", absolute=true)
    public Response deleteGraphExtension(@PathParam(value="graphname") String graphName, JSONObject json) {
        this.setRequestObject(json);
        return this.executeGraphExtension(graphName, HttpMethod.DELETE);
    }

    @DELETE
    @Path(value="{extension: (?!vertices)(?!edges)(?!indices)(?!keyindices)(?!prefixes).+}")
    @Timed(name="http.rest.graphs.extension.delete", absolute=true)
    public Response deleteGraphExtension(@PathParam(value="graphname") String graphName) {
        return this.executeGraphExtension(graphName, HttpMethod.DELETE);
    }

    @POST
    @Path(value="{extension: (?!vertices)(?!edges)(?!indices)(?!keyindices)(?!prefixes).+}")
    @Consumes(value={"application/json"})
    @Timed(name="http.rest.graphs.extension.post", absolute=true)
    public Response postGraphExtension(@PathParam(value="graphname") String graphName, JSONObject json) {
        this.setRequestObject(json);
        return this.executeGraphExtension(graphName, HttpMethod.POST);
    }

    @POST
    @Path(value="{extension: (?!vertices)(?!edges)(?!indices)(?!keyindices)(?!prefixes).+}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Timed(name="http.rest.graphs.extension.post", absolute=true)
    public Response postGraphExtension(@PathParam(value="graphname") String graphName, MultivaluedMap<String, String> formParams) {
        this.setRequestObject(formParams);
        return this.executeGraphExtension(graphName, HttpMethod.POST);
    }

    @POST
    @Path(value="{extension: (?!vertices)(?!edges)(?!indices)(?!keyindices)(?!prefixes).+}")
    @Timed(name="http.rest.graphs.extension.post", absolute=true)
    public Response postGraphExtension(@PathParam(value="graphname") String graphName) {
        return this.executeGraphExtension(graphName, HttpMethod.POST);
    }

    @GET
    @Path(value="{extension: (?!vertices)(?!edges)(?!indices)(?!keyindices)(?!prefixes).+}")
    @Timed(name="http.rest.graphs.extension.post", absolute=true)
    public Response getGraphExtension(@PathParam(value="graphname") String graphName) {
        return this.executeGraphExtension(graphName, HttpMethod.GET);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response executeGraphExtension(String graphName, HttpMethod httpMethodRequested) {
        ExtensionMethod methodToCall;
        ExtensionSegmentSet extensionSegmentSet = this.parseUriForExtensionSegment(graphName, ExtensionPoint.GRAPH);
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        if (!rag.isExtensionAllowed(extensionSegmentSet)) {
            logger.error((Object)("The [" + extensionSegmentSet + "] extension was not configured for [" + graphName + "]"));
            JSONObject error = this.generateErrorObject("The [" + extensionSegmentSet + "] extension was not configured for [" + graphName + "]");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        Object returnValue = null;
        try {
            List<RexsterExtension> rexsterExtensions = null;
            try {
                rexsterExtensions = GraphResource.findExtensionClasses(extensionSegmentSet);
            }
            catch (ServiceConfigurationError sce) {
                logger.error((Object)"ServiceLoader could not find a class referenced in com.tinkerpop.rexster.extension.RexsterExtension.");
                JSONObject error = this.generateErrorObject("Class specified in com.tinkerpop.rexster.extension.RexsterExtension could not be found.", sce);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            if (rexsterExtensions == null || rexsterExtensions.size() == 0) {
                logger.error((Object)("The [" + extensionSegmentSet + "] extension was not found for [" + graphName + "].  Check com.tinkerpop.rexster.extension.RexsterExtension file in META-INF.services."));
                JSONObject error = this.generateErrorObject("The [" + extensionSegmentSet + "] extension was not found for [" + graphName + "]");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            methodToCall = GraphResource.findExtensionMethod(rexsterExtensions, ExtensionPoint.GRAPH, extensionSegmentSet.getExtensionMethod(), httpMethodRequested);
            if (methodToCall == null) {
                if (httpMethodRequested == HttpMethod.OPTIONS) {
                    return this.buildOptionsResponse();
                }
                logger.error((Object)("The [" + extensionSegmentSet + "] extension was not found for [" + graphName + "] with a HTTP method of [" + httpMethodRequested.name() + "].  Check com.tinkerpop.rexster.extension.RexsterExtension file in META-INF.services."));
                JSONObject error = this.generateErrorObject("The [" + extensionSegmentSet + "] extension was not found for [" + graphName + "] with a HTTP method of [" + httpMethodRequested.name() + "]");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            returnValue = this.invokeExtension(rag, methodToCall);
            rag.tryCommit();
        }
        catch (WebApplicationException wae) {
            rag.tryRollback();
            throw wae;
        }
        catch (Exception ex) {
            logger.error((Object)("Dynamic invocation of the [" + extensionSegmentSet + "] extension failed."), (Throwable)ex);
            if (ex.getCause() != null) {
                Throwable cause = ex.getCause();
                logger.error((Object)("It would be smart to trap this this exception within the extension and supply a good response to the user:" + cause.getMessage()), cause);
            }
            rag.tryRollback();
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        if (!(returnValue instanceof ExtensionResponse)) {
            logger.error((Object)("The [" + extensionSegmentSet + "] extension does not return an ExtensionResponse."));
            JSONObject error = this.generateErrorObject("The [" + extensionSegmentSet + "] extension does not return an ExtensionResponse.");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        ExtensionResponse extResponse = (ExtensionResponse)returnValue;
        if (extResponse.isErrorResponse()) {
            logger.warn((Object)("The [" + extensionSegmentSet + "] extension raised an error response."));
            if (methodToCall.getExtensionDefinition().autoCommitTransaction()) {
                rag.tryRollback();
            }
            throw new WebApplicationException(Response.fromResponse((Response)extResponse.getJerseyResponse()).build());
        }
        if (methodToCall.getExtensionDefinition().autoCommitTransaction()) {
            rag.tryCommit();
        }
        String mediaType = "application/json";
        if (methodToCall != null) {
            mediaType = methodToCall.getExtensionDefinition().produces();
            extResponse = this.tryAppendRexsterAttributesIfJson(extResponse, methodToCall, mediaType);
        }
        return Response.fromResponse((Response)extResponse.getJerseyResponse()).type(mediaType).build();
    }
}

