/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.config;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.impls.neo4j.Neo4jGraph;
import com.tinkerpop.blueprints.impls.neo4j.Neo4jHaGraph;
import com.tinkerpop.rexster.config.GraphConfiguration;
import com.tinkerpop.rexster.config.GraphConfigurationContext;
import com.tinkerpop.rexster.config.GraphConfigurationException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;

public class Neo4jGraphConfiguration
implements GraphConfiguration {
    public Graph configureGraphInstance(GraphConfigurationContext context) throws GraphConfigurationException {
        SubnodeConfiguration neo4jSpecificConfiguration;
        String graphFile = context.getProperties().getString("graph-location");
        if (graphFile == null || graphFile.length() == 0) {
            throw new GraphConfigurationException("Check graph configuration. Missing or empty configuration element: graph-location");
        }
        boolean highAvailabilityMode = context.getProperties().getBoolean("graph-high-availability", false);
        HierarchicalConfiguration graphSectionConfig = (HierarchicalConfiguration)context.getProperties();
        try {
            neo4jSpecificConfiguration = graphSectionConfig.configurationAt("properties");
        }
        catch (IllegalArgumentException iae) {
            throw new GraphConfigurationException("Check graph configuration. Missing or empty configuration element: properties");
        }
        try {
            HashMap<String, String> neo4jProperties = new HashMap<String, String>();
            Iterator neo4jSpecificConfigurationKeys = neo4jSpecificConfiguration.getKeys();
            while (neo4jSpecificConfigurationKeys.hasNext()) {
                String key = (String)neo4jSpecificConfigurationKeys.next();
                neo4jProperties.put(key.replace("..", "."), neo4jSpecificConfiguration.getString(key));
            }
            if (highAvailabilityMode) {
                if (!neo4jProperties.containsKey("ha.machine_id")) {
                    throw new GraphConfigurationException("Check graph configuration. Neo4j HA requires [ha.machine_id] in the <properties> of the configuration");
                }
                if (!neo4jProperties.containsKey("ha.server")) {
                    throw new GraphConfigurationException("Check graph configuration. Neo4j HA requires [ha.server] <properties> of the configuration");
                }
                if (!neo4jProperties.containsKey("ha.initial_hosts")) {
                    throw new GraphConfigurationException("Check graph configuration. Neo4j HA requires [ha.initial_hosts] <properties> of the configuration");
                }
                return new Neo4jHaGraph(graphFile, neo4jProperties);
            }
            return new Neo4jGraph(graphFile, neo4jProperties);
        }
        catch (GraphConfigurationException gce) {
            throw gce;
        }
        catch (Exception ex) {
            throw new GraphConfigurationException((Throwable)ex);
        }
    }
}

