/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.filter;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.lang.NullArgumentException;
import org.apache.log4j.Logger;

public class CharsetHolder
implements Comparable<CharsetHolder> {
    private static final Logger logger = Logger.getLogger(CharsetHolder.class);
    private final String charset;
    private final float quality;
    private final int order;
    private static final int CACHE_MAX_SIZE = 1000;
    private static final Map<String, CharsetHolder> charsetCache = Collections.synchronizedMap(new LinkedHashMap(1000){
        private static final long serialVersionUID = 2546245625L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1000;
        }
    });

    public CharsetHolder(String charset, float quality, int order) {
        if (charset == null) {
            throw new NullArgumentException("charset");
        }
        this.charset = charset;
        this.quality = quality;
        this.order = order;
    }

    public String getCharset() {
        return this.charset;
    }

    public float getQuality() {
        return this.quality;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isSupported() {
        try {
            return Charset.isSupported(this.charset);
        }
        catch (IllegalCharsetNameException icne) {
            logger.debug((Object)"Illegal charset requested.", (Throwable)icne);
            return false;
        }
    }

    public static CharsetHolder getFirstSupportedCharset(String acceptCharsetHeaderValue) {
        CharsetHolder firstSupportedCharset = null;
        if (charsetCache.containsKey(acceptCharsetHeaderValue)) {
            firstSupportedCharset = charsetCache.get(acceptCharsetHeaderValue);
        } else {
            List<CharsetHolder> charsetRanks = CharsetHolder.getAcceptableCharsets(acceptCharsetHeaderValue);
            for (CharsetHolder charsetRank : charsetRanks) {
                if (!charsetRank.isSupported()) continue;
                firstSupportedCharset = charsetRank;
                break;
            }
            charsetCache.put(acceptCharsetHeaderValue, firstSupportedCharset);
        }
        return firstSupportedCharset;
    }

    public static List<CharsetHolder> getAcceptableCharsets(String acceptCharsetHeaderValue) {
        CharsetHolder otherCharsetHolder;
        ArrayList<CharsetHolder> charsetHolders = new ArrayList<CharsetHolder>();
        String[] charsetStrings = acceptCharsetHeaderValue.split(",");
        int order = 0;
        CharsetHolder asteriskCharset = null;
        for (String charsetString : charsetStrings) {
            try {
                String[] qualityPair;
                float qualityValue = 1.0f;
                String[] charsetComponents = charsetString.split(";");
                String charsetValue = charsetComponents[0];
                if (charsetComponents.length == 2 && (qualityPair = charsetComponents[1].trim().split("=")).length == 2) {
                    qualityValue = Float.parseFloat(qualityPair[1].trim());
                }
                if (charsetValue.equals("*")) {
                    asteriskCharset = new CharsetHolder("*", qualityValue, order);
                } else {
                    charsetHolders.add(new CharsetHolder(charsetValue, qualityValue, order));
                }
            }
            catch (Exception ex) {
                logger.warn((Object)("Charset from the request (or rexster.xml) is not valid: [" + charsetString + "]."));
            }
            ++order;
        }
        SortedMap<String, Charset> availableCharsets = Charset.availableCharsets();
        if (asteriskCharset == null) {
            for (Map.Entry<String, Charset> availableCharset : availableCharsets.entrySet()) {
                otherCharsetHolder = new CharsetHolder(availableCharset.getKey(), 0.0f, Integer.MAX_VALUE);
                if (availableCharset.getKey().equals("ISO-8859-1")) {
                    otherCharsetHolder = new CharsetHolder(availableCharset.getKey(), 1.0f, Integer.MAX_VALUE);
                }
                if (charsetHolders.contains(otherCharsetHolder)) continue;
                charsetHolders.add(otherCharsetHolder);
            }
        } else {
            for (Map.Entry<String, Charset> availableCharset : availableCharsets.entrySet()) {
                otherCharsetHolder = new CharsetHolder(availableCharset.getKey(), asteriskCharset.getQuality(), 0);
                if (charsetHolders.contains(otherCharsetHolder)) continue;
                charsetHolders.add(otherCharsetHolder);
            }
        }
        Collections.sort(charsetHolders);
        return charsetHolders;
    }

    @Override
    public int compareTo(CharsetHolder charsetHolder) {
        int compare;
        int n = this.quality == charsetHolder.getQuality() ? 0 : (compare = this.quality > charsetHolder.getQuality() ? -1 : 1);
        if (compare == 0) {
            compare = this.order == charsetHolder.getOrder() ? 0 : (this.order > charsetHolder.getOrder() ? 1 : -1);
        }
        return compare;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharsetHolder that = (CharsetHolder)o;
        return this.charset.equals(that.charset);
    }

    public int hashCode() {
        return this.charset.hashCode();
    }
}

