/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.server;

import com.codahale.metrics.JmxAttributeGauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.tinkerpop.rexster.filter.AbstractSecurityFilter;
import com.tinkerpop.rexster.filter.DefaultSecurityFilter;
import com.tinkerpop.rexster.protocol.filter.RexProProcessorFilter;
import com.tinkerpop.rexster.protocol.filter.RexProServerFilter;
import com.tinkerpop.rexster.protocol.session.RexProSessionMonitor;
import com.tinkerpop.rexster.server.GrizzlyIoStrategyFactory;
import com.tinkerpop.rexster.server.RexsterApplication;
import com.tinkerpop.rexster.server.RexsterProperties;
import com.tinkerpop.rexster.server.RexsterServer;
import java.util.concurrent.TimeUnit;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.monitoring.jmx.GrizzlyJmxManager;
import org.glassfish.grizzly.monitoring.jmx.JmxObject;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;

public class RexProRexsterServer
implements RexsterServer {
    private static final Logger logger = Logger.getLogger(RexProRexsterServer.class);
    private RexsterApplication app;
    private RexsterProperties properties;
    private Integer rexproServerPort;
    private String rexproServerHost;
    private final TCPNIOTransport tcpTransport;
    private boolean allowSessions;
    private int maxWorkerThreadPoolSize;
    private int coreWorkerThreadPoolSize;
    private int maxKernalThreadPoolSize;
    private int coreKernalThreadPoolSize;
    private long connectionIdleMax;
    private long connectionIdleInterval;
    private int transportReadBuffer;
    private boolean enableJmx;
    private String ioStrategy;
    private JmxObject jmx;
    private RexProSessionMonitor rexProSessionMonitor = new RexProSessionMonitor();
    private String lastIoStrategy;
    private boolean lastEnableJmx;
    private int lastMaxWorkerThreadPoolSize;
    private int lastCoreWorkerThreadPoolSize;
    private int lastMaxKernalThreadPoolSize;
    private int lastCoreKernalThreadPoolSize;
    private long lastConnectionIdleMax;
    private long lastConnectionIdleInterval;
    private int lastTransportReadBuffer;

    public RexProRexsterServer(XMLConfiguration configuration) {
        this(configuration, true);
    }

    public RexProRexsterServer(XMLConfiguration configuration, boolean allowSessions) {
        this(new RexsterProperties(configuration), allowSessions);
    }

    public RexProRexsterServer(RexsterProperties properties, boolean allowSessions) {
        this.allowSessions = allowSessions;
        this.properties = properties;
        this.updateSettings(properties.getConfiguration());
        this.tcpTransport = TCPNIOTransportBuilder.newInstance().build();
        properties.addListener(new RexsterProperties.RexsterPropertiesListener(){

            @Override
            public void propertiesChanged(XMLConfiguration configuration) {
                RexProRexsterServer.this.lastEnableJmx = RexProRexsterServer.this.enableJmx;
                RexProRexsterServer.this.lastIoStrategy = RexProRexsterServer.this.ioStrategy;
                RexProRexsterServer.this.lastMaxWorkerThreadPoolSize = RexProRexsterServer.this.maxWorkerThreadPoolSize;
                RexProRexsterServer.this.lastCoreWorkerThreadPoolSize = RexProRexsterServer.this.coreWorkerThreadPoolSize;
                RexProRexsterServer.this.lastMaxKernalThreadPoolSize = RexProRexsterServer.this.maxKernalThreadPoolSize;
                RexProRexsterServer.this.lastCoreKernalThreadPoolSize = RexProRexsterServer.this.coreKernalThreadPoolSize;
                RexProRexsterServer.this.lastConnectionIdleInterval = RexProRexsterServer.this.connectionIdleInterval;
                RexProRexsterServer.this.lastConnectionIdleMax = RexProRexsterServer.this.connectionIdleMax;
                RexProRexsterServer.this.lastTransportReadBuffer = RexProRexsterServer.this.transportReadBuffer;
                RexProRexsterServer.this.updateSettings(configuration);
                try {
                    RexProRexsterServer.this.reconfigure(RexProRexsterServer.this.app);
                }
                catch (Exception ex) {
                    logger.error((Object)"Could not modify Rexster configuration.  Please restart Rexster to allow changes to be applied.", (Throwable)ex);
                }
            }
        });
    }

    @Override
    public void stop() throws Exception {
        this.tcpTransport.stop();
    }

    @Override
    public void start(RexsterApplication application) throws Exception {
        this.app = application;
        this.reconfigure(application);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigure(RexsterApplication application) throws Exception {
        this.configureTransport();
        if (this.hasEnableJmxChanged()) {
            if (this.enableJmx) {
                this.jmx = this.tcpTransport.getMonitoringConfig().createManagementObject();
                GrizzlyJmxManager.instance().registerAtRoot(this.jmx, "RexPro");
                this.manageJmxMetrics(application, true);
                logger.info((Object)"JMX enabled on RexPro.");
            } else if (this.jmx != null) {
                try {
                    GrizzlyJmxManager.instance().deregister(this.jmx);
                    this.manageJmxMetrics(application, false);
                }
                catch (IllegalArgumentException iae) {
                    logger.debug((Object)"Could not deregister JMX object on restart.  Perhaps it was never initially registered.");
                }
                finally {
                    this.jmx = null;
                }
                logger.info((Object)"JMX disabled on RexPro.");
            }
        }
        if (this.tcpTransport.isStopped()) {
            this.tcpTransport.start();
        }
        if (this.hasSessionIdleChanged()) {
            this.rexProSessionMonitor.reconfigure(this.connectionIdleInterval, this.connectionIdleMax);
        }
    }

    private void manageJmxMetrics(RexsterApplication application, boolean register) throws MalformedObjectNameException {
        MetricRegistry metricRegistry = application.getMetricRegistry();
        RexProRexsterServer.manageMetricsFromJmx(metricRegistry, register);
        logger.info((Object)(register ? "Registered JMX Metrics." : "Removed JMX Metrics."));
    }

    private boolean hasEnableJmxChanged() {
        return this.enableJmx != this.lastEnableJmx;
    }

    private boolean hasIoStrategyChanged() {
        return !this.ioStrategy.equals(this.lastIoStrategy);
    }

    private boolean hasThreadPoolSizeChanged() {
        return this.maxKernalThreadPoolSize != this.lastMaxKernalThreadPoolSize || this.maxWorkerThreadPoolSize != this.lastMaxWorkerThreadPoolSize || this.coreKernalThreadPoolSize != this.lastCoreKernalThreadPoolSize || this.coreWorkerThreadPoolSize != this.lastCoreWorkerThreadPoolSize;
    }

    private boolean hasSessionIdleChanged() {
        return this.connectionIdleInterval != this.lastConnectionIdleInterval || this.connectionIdleMax != this.lastConnectionIdleMax;
    }

    private void updateSettings(XMLConfiguration configuration) {
        this.rexproServerPort = configuration.getInteger("rexpro.server-port", new Integer(8184));
        this.rexproServerHost = configuration.getString("rexpro.server-host", "0.0.0.0");
        this.coreWorkerThreadPoolSize = configuration.getInt("rexpro.thread-pool.worker.core-size", 8);
        this.maxWorkerThreadPoolSize = configuration.getInt("rexpro.thread-pool.worker.max-size", 8);
        this.coreKernalThreadPoolSize = configuration.getInt("rexpro.thread-pool.kernal.core-size", 4);
        this.maxKernalThreadPoolSize = configuration.getInt("rexpro.thread-pool.kernal.max-size", 4);
        this.connectionIdleMax = configuration.getLong("rexpro.connection-max-idle", new Long(1790000L));
        this.connectionIdleInterval = configuration.getLong("rexpro.connection-check-interval", new Long(3000000L));
        this.enableJmx = configuration.getBoolean("rexpro.enable-jmx", false);
        this.ioStrategy = configuration.getString("rexpro.io-strategy", "leader-follower");
        this.transportReadBuffer = configuration.getInt("rexpro.read-buffer", 65536);
    }

    private FilterChain constructFilterChain(RexsterApplication application) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String securityFilterType;
        FilterChainBuilder filterChainBuilder = FilterChainBuilder.stateless();
        filterChainBuilder.add((Filter)new TransportFilter());
        filterChainBuilder.add((Filter)new IdleTimeoutFilter(IdleTimeoutFilter.createDefaultIdleDelayedExecutor((long)this.connectionIdleInterval, (TimeUnit)TimeUnit.MILLISECONDS), this.connectionIdleMax, TimeUnit.MILLISECONDS));
        filterChainBuilder.add((Filter)new RexProServerFilter(application));
        HierarchicalConfiguration securityConfiguration = this.properties.getSecuritySettings();
        String string = securityFilterType = securityConfiguration != null ? securityConfiguration.getString("type") : "none";
        if (securityFilterType.equals("none")) {
            logger.info((Object)"Rexster configured with no security.");
        } else {
            AbstractSecurityFilter filter;
            if (securityFilterType.equals("default")) {
                filter = new DefaultSecurityFilter();
                filterChainBuilder.add((Filter)filter);
            } else {
                filter = (AbstractSecurityFilter)((Object)Class.forName(securityFilterType).newInstance());
                filterChainBuilder.add((Filter)filter);
            }
            filter.configure(this.properties.getConfiguration());
            logger.info((Object)("Rexster configured with [" + filter.getName() + "]."));
        }
        filterChainBuilder.add((Filter)new RexProProcessorFilter());
        return filterChainBuilder.build();
    }

    private static void manageMetricsFromJmx(MetricRegistry metricRegistry, boolean register) throws MalformedObjectNameException {
        String jmxObjectMemoryManager = "org.glassfish.grizzly:pp=/gmbal-root/TCPNIOTransport[RexPro],type=HeapMemoryManager,name=MemoryManager";
        String metricGroupMemoryManager = "heap-memory-manager";
        String[] heapMemoryManagerMetrics = new String[]{"pool-allocated-bytes", "pool-released-bytes", "real-allocated-bytes", "total-allocated-bytes"};
        RexProRexsterServer.manageJmxKeysAsMetric(metricRegistry, "org.glassfish.grizzly:pp=/gmbal-root/TCPNIOTransport[RexPro],type=HeapMemoryManager,name=MemoryManager", "heap-memory-manager", heapMemoryManagerMetrics, register);
        String jmxObjectTcpNioTransport = "org.glassfish.grizzly:pp=/gmbal-root,type=TCPNIOTransport,name=RexPro";
        String metricGroupTcpNioTransport = "tcp-nio-transport";
        String[] tcpNioTransportMetrics = new String[]{"bound-addresses", "bytes-read", "bytes-written", "client-connect-timeout-millis", "io-strategy", "open-connections-count", "read-buffer-size", "selector-threads-count", "server-socket-so-timeout", "total-connections-count", "write-buffer-size"};
        RexProRexsterServer.manageJmxKeysAsMetric(metricRegistry, "org.glassfish.grizzly:pp=/gmbal-root,type=TCPNIOTransport,name=RexPro", "tcp-nio-transport", tcpNioTransportMetrics, register);
        String jmxObjectThreadPool = "org.glassfish.grizzly:pp=/gmbal-root/TCPNIOTransport[RexPro],type=ThreadPool,name=ThreadPool";
        String metricGroupThreadPool = "thread-pool";
        String[] threadPoolMetrics = new String[]{"thread-pool-allocated-thread-count", "thread-pool-core-pool-size", "thread-pool-max-num-threads", "thread-pool-queued-task-count", "thread-pool-task-queue-overflow-count", "thread-pool-total-allocated-thread-count", "thread-pool-total-completed-tasks-count", "thread-pool-type"};
        RexProRexsterServer.manageJmxKeysAsMetric(metricRegistry, "org.glassfish.grizzly:pp=/gmbal-root/TCPNIOTransport[RexPro],type=ThreadPool,name=ThreadPool", "thread-pool", threadPoolMetrics, register);
    }

    private static void manageJmxKeysAsMetric(MetricRegistry metricRegistry, String jmxObjectName, String metricGroup, String[] metricKeys, boolean register) throws MalformedObjectNameException {
        for (String metricKey : metricKeys) {
            if (register) {
                RexProRexsterServer.registerJmxKeyAsMetric(metricRegistry, metricGroup, jmxObjectName, metricKey);
                continue;
            }
            RexProRexsterServer.deregisterJmxKeyAsMetric(metricRegistry, metricGroup, metricKey);
        }
    }

    private static void registerJmxKeyAsMetric(MetricRegistry metricRegistry, String metricGroup, String jmxObjectName, String jmxAttributeName) throws MalformedObjectNameException {
        metricRegistry.register(MetricRegistry.name((String)"rexpro", (String[])new String[]{"core", metricGroup, jmxAttributeName}), (Metric)new JmxAttributeGauge(new ObjectName(jmxObjectName), jmxAttributeName));
    }

    private static void deregisterJmxKeyAsMetric(MetricRegistry metricRegistry, String metricGroup, String jmxAttributeName) throws MalformedObjectNameException {
        metricRegistry.remove(MetricRegistry.name((String)"rexpro", (String[])new String[]{"core", metricGroup, jmxAttributeName}));
    }

    private void configureTransport() throws Exception {
        if (this.hasIoStrategyChanged()) {
            IOStrategy strategy = GrizzlyIoStrategyFactory.createIoStrategy(this.ioStrategy);
            this.tcpTransport.setIOStrategy(strategy);
            logger.info((Object)String.format("Using %s IOStrategy for RexPro.", strategy.getClass().getName()));
        }
        if (this.lastTransportReadBuffer != this.transportReadBuffer) {
            this.tcpTransport.setReadBufferSize(this.transportReadBuffer);
        }
        if (this.hasThreadPoolSizeChanged()) {
            ThreadPoolConfig workerThreadPoolConfig = ThreadPoolConfig.defaultConfig().setCorePoolSize(this.coreWorkerThreadPoolSize).setMaxPoolSize(this.maxWorkerThreadPoolSize);
            this.tcpTransport.setWorkerThreadPoolConfig(workerThreadPoolConfig);
            ThreadPoolConfig kernalThreadPoolConfig = ThreadPoolConfig.defaultConfig().setCorePoolSize(this.coreKernalThreadPoolSize).setMaxPoolSize(this.maxKernalThreadPoolSize);
            this.tcpTransport.setKernelThreadPoolConfig(kernalThreadPoolConfig);
            if (this.tcpTransport.getKernelThreadPool() != null) {
                ((GrizzlyExecutorService)this.tcpTransport.getKernelThreadPool()).reconfigure(kernalThreadPoolConfig);
            }
            if (this.tcpTransport.getWorkerThreadPool() != null) {
                ((GrizzlyExecutorService)this.tcpTransport.getWorkerThreadPool()).reconfigure(workerThreadPoolConfig);
            }
            logger.info((Object)String.format("RexPro thread pool configuration: kernal[%s / %s] worker[%s / %s] ", this.coreKernalThreadPoolSize, this.maxKernalThreadPoolSize, this.coreWorkerThreadPoolSize, this.maxWorkerThreadPoolSize));
        }
        this.tcpTransport.setProcessor((Processor)this.constructFilterChain(this.app));
        this.tcpTransport.unbindAll();
        this.tcpTransport.bind(this.rexproServerHost, this.rexproServerPort.intValue());
        logger.info((Object)String.format("RexPro Server bound to [%s:%s]", this.rexproServerHost, this.rexproServerPort));
    }
}

